/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.openide.awt.Mnemonics;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

final class AlwaysEnabledAction
extends AbstractAction
implements PropertyChangeListener,
ContextAwareAction {
    private final Map map;
    private ActionListener delegate;
    private final Lookup context;
    private final Object equals;

    public AlwaysEnabledAction(Map map) {
        this.map = map;
        this.context = null;
        this.equals = this;
    }

    private AlwaysEnabledAction(Map map, ActionListener actionListener, Lookup lookup, Object object) {
        this.map = map;
        this.delegate = AlwaysEnabledAction.bindToContext(actionListener, lookup);
        this.context = lookup;
        this.equals = object;
    }

    private static ActionListener bindToContext(ActionListener actionListener, Lookup lookup) {
        if (lookup != null && actionListener instanceof ContextAwareAction) {
            return ((ContextAwareAction)actionListener).createContextAwareInstance(lookup);
        }
        return actionListener;
    }

    private ActionListener getDelegate() {
        if (this.delegate == null) {
            Object v = this.map.get("delegate");
            if (!(v instanceof ActionListener)) {
                throw new NullPointerException();
            }
            this.delegate = AlwaysEnabledAction.bindToContext((ActionListener)v, this.context);
            if (this.delegate instanceof Action) {
                ((Action)this.delegate).addPropertyChangeListener(this);
            }
        }
        return this.delegate;
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        if (this.delegate instanceof Action) {
            return ((Action)this.delegate).isEnabled();
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (EventQueue.isDispatchThread());
        if (this.getDelegate() instanceof Action && !((Action)this.getDelegate()).isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            this.firePropertyChange(null, null, null);
            return;
        }
        this.getDelegate().actionPerformed(actionEvent);
    }

    public Object getValue(String string) {
        Object object;
        if (this.delegate instanceof Action && (object = ((Action)this.delegate).getValue(string)) != null) {
            return object;
        }
        return AlwaysEnabledAction.extractCommonAttribute(this.map, this, string);
    }

    static final Object extractCommonAttribute(Map map, Action action, String string) {
        Keymap keymap;
        if ("Name".equals(string)) {
            String string2 = (String)map.get("displayName");
            return string2;
        }
        if ("MnemonicKey".equals(string)) {
            String string3 = (String)map.get("displayName");
            int n = Mnemonics.findMnemonicAmpersand(string3);
            return n == -1 ? null : Character.valueOf(string3.charAt(n + 1));
        }
        if ("SmallIcon".equals(string)) {
            Keymap keymap2 = keymap = map == null ? null : (Keymap)map.get("iconBase");
            if (keymap instanceof Icon) {
                return (Icon)((Object)keymap);
            }
            if (keymap instanceof Image) {
                return ImageUtilities.image2Icon((Image)((Image)((Object)keymap)));
            }
            if (keymap instanceof String) {
                return ImageUtilities.loadImage((String)((String)((Object)keymap)));
            }
            if (keymap instanceof URL) {
                return Toolkit.getDefaultToolkit().getImage((URL)((Object)keymap));
            }
        }
        if ("iconBase".equals(string)) {
            return map == null ? null : map.get("iconBase");
        }
        if ("noIconInMenu".equals(string)) {
            return map == null ? null : map.get("noIconInMenu");
        }
        if ("AcceleratorKey".equals(string) && (keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class)) != null) {
            KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
            return keyStrokeArray.length > 0 ? keyStrokeArray[0] : null;
        }
        return null;
    }

    public int hashCode() {
        if (this.equals == this) {
            return super.hashCode();
        }
        return this.equals.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AlwaysEnabledAction) {
            AlwaysEnabledAction alwaysEnabledAction = (AlwaysEnabledAction)object;
            if (this.equals.equals(alwaysEnabledAction.equals)) {
                return false;
            }
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.delegate) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new AlwaysEnabledAction(this.map, this.delegate, lookup, this.equals);
    }
}

