//////////////////////////////////////////////////////////////////////////////
// Name:        SVGAnimationElement.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_ANIMATION_ELEMENT_H
#define WX_SVG_ANIMATION_ELEMENT_H

class wxSVGElement;

#include "SVGElement.h"
#include "SVGTests.h"
#include "SVGExternalResourcesRequired.h"
#include "ElementTimeControl.h"
#include "EventTarget.h"
#include "String_wxsvg.h"
#include "Element.h"

class wxSVGAnimationElement:
  public wxSVGElement,
  public wxSVGTests,
  public wxSVGExternalResourcesRequired,
  public wxElementTimeControl,
  public wxEventTarget
{
  protected:
    wxSVGElement* m_targetElement;

  public:
    inline wxSVGElement* GetTargetElement() const { return m_targetElement; }
    inline void SetTargetElement(wxSVGElement* n) { m_targetElement = n; }

  public:
    wxSVGAnimationElement(wxString tagName = wxT("")):
      wxSVGElement(tagName), m_targetElement(NULL) {}
    virtual ~wxSVGAnimationElement() {}
    virtual double GetStartTime();
    virtual double GetCurrentTime();
    virtual double GetSimpleDuration();
    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxSvgXmlAttrHash GetAttributes() const;
};

#endif // WX_SVG_ANIMATION_ELEMENT_H
