/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pdftools;

import de.tu_darmstadt.sp.pudl.Document;
import de.tu_darmstadt.sp.pudl.Page;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PageSelect {
    static final String PROGRAM = "pdfselect";
    static final String VERSION = "0.1";
    private static final String shortOpts = "qeorp:hV";
    private static final LongOpt[] longOpts = new LongOpt[]{new LongOpt("pages", 1, null, 112), new LongOpt("quiet", 0, null, 113), new LongOpt("even", 0, null, 101), new LongOpt("odd", 0, null, 111), new LongOpt("reverse", 0, null, 114), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86)};
    private static int verbosityLevel = 1;

    public static void main(String[] args) {
        File inFile = null;
        File outFile = null;
        List pageRanges = new ArrayList<Integer>();
        pageRanges.add(new Integer(1));
        pageRanges.add(new Integer(Integer.MAX_VALUE));
        boolean reverse = false;
        boolean even = false;
        boolean odd = false;
        try {
            int opt;
            Getopt options = new Getopt(PROGRAM, args, shortOpts, longOpts);
            while ((opt = options.getopt()) != -1) {
                switch (opt) {
                    case 112: {
                        pageRanges = PageSelect.parseRanges(options.getOptarg());
                        break;
                    }
                    case 114: {
                        reverse = true;
                        break;
                    }
                    case 101: {
                        even = true;
                        break;
                    }
                    case 111: {
                        odd = true;
                        break;
                    }
                    case 113: {
                        verbosityLevel = 0;
                        break;
                    }
                    case 104: {
                        PageSelect.showUsage(null);
                        break;
                    }
                    case 86: {
                        PageSelect.showVersion();
                        break;
                    }
                    default: {
                        PageSelect.showUsage("Illegal option '" + (char)options.getOptopt() + "' detected.");
                    }
                }
            }
            if (options.getOptind() + 1 == args.length) {
                inFile = new File(args[options.getOptind()]);
                outFile = null;
            } else if (options.getOptind() + 2 == args.length) {
                inFile = new File(args[options.getOptind()]);
                outFile = new File(args[options.getOptind() + 1]);
            } else {
                PageSelect.showUsage("You must specify PDF files to process.");
            }
        }
        catch (Exception e) {
            PageSelect.showUsage("Error: " + e.getMessage());
        }
        try {
            PageSelect.progress(2, "reading: " + inFile.toString() + "\n");
            Document in = new Document(inFile);
            Document out = new Document();
            Iterator i = pageRanges.iterator();
            int noPages = 0;
            PageSelect.progress(2, "checkout begin:\n");
            while (i.hasNext()) {
                boolean done = false;
                int beg = (Integer)i.next();
                int end = (Integer)i.next();
                PageSelect.progress(2, "selecting from " + beg + " to " + end + "\n");
                int e = beg;
                while (!done) {
                    try {
                        PageSelect.progress(2, "checking out page: " + e + "\n");
                        Page p = in.checkoutPage(e);
                        if (!odd && even && e % 2 != 0) {
                            p = null;
                        }
                        if (!even && odd && e % 2 != 1) {
                            p = null;
                        }
                        if (p != null) {
                            if (reverse) {
                                out.addPage(1, p);
                            } else {
                                out.addPage(p);
                            }
                            PageSelect.progress(1, "[" + e + "] ");
                            ++noPages;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    done = beg <= end ? ++e > end : --e < beg;
                    boolean bl = done = done || in.numPages() < e || e < 1;
                }
            }
            if (outFile == null) {
                out.write(System.out);
            } else {
                out.write(outFile);
                PageSelect.progress(1, "Wrote " + noPages + " pages, " + outFile.length() + " bytes\n");
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException occured!");
        }
    }

    private static List parseRanges(String r) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        StringTokenizer tok = new StringTokenizer(r, ",");
        while (tok.hasMoreTokens()) {
            String range = tok.nextToken();
            int index = range.indexOf("-");
            if (index == -1) {
                result.add(new Integer(range));
                result.add(new Integer(range));
                continue;
            }
            if (index == 0) {
                if (range.length() == 1) {
                    result.add(new Integer(1));
                    result.add(new Integer(Integer.MAX_VALUE));
                    continue;
                }
                result.add(new Integer(1));
                result.add(new Integer(range.substring(1)));
                continue;
            }
            if (index == range.length() - 1) {
                result.add(new Integer(range.substring(0, range.length() - 1)));
                result.add(new Integer(Integer.MAX_VALUE));
                continue;
            }
            result.add(new Integer(range.substring(0, index)));
            result.add(new Integer(range.substring(index + 1, range.length())));
        }
        return result;
    }

    private static void progress(int level, String msg) {
        if (verbosityLevel >= level) {
            System.err.print(msg);
        }
    }

    private static void showUsage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("Usage: pdfselect [options] infile [outfile]\nOptions:\n-p N, --pages N\t\tIntervals of pages to be selected.\n-q, --quiet\t\tDo not print progress messages.\n-e, --even\t\tSelect even pages. It may be used in conjunction with the other page selection options to select the even pages from a range of pages.\n-o, --odd\t\t        Select odd pages. It may be used in conjunction with the other page selection options to select the even pages from a range of pages.\n-r, --reverse\t\tThe -r option causes pdfselect to output the selected pages in reverse order.\n-h, --help\t\tPrint this message and exit.\n-V, --version\t\tShow version number.\n");
        System.exit(1);
    }

    private static void showVersion() {
        System.err.println("pdfselect version 0.1\nCopyright (C) 1999, 2000 FG Systemprogrammierung, TU Darmstadt\npdfselect is free software; see the source for copying conditions.\nThere is NO warranty; not even for MERCHANTABILITY or FITNESS\nFOR A PARTICULAR PURPOSE.\n");
        System.exit(0);
    }
}

