##############################################################################
#
# Entry.py
# Classes for Entriy
#
# Copyright (c) 2003-2004 Atsushi Shibata. All Rights Reserved.
#
# Permission to use, copy, modify, and distribute this software and its 
# documentation for any purpose and without fee is hereby granted, provided that
# the above copyright notice appear in all copies and that both that copyright 
# notice and this permission notice appear in supporting documentation, and that
# the name of Atsushi Shibata not be used in advertising or publicity pertaining 
# to distribution of the software without specific, written prior permission. 
# 
# ATSUSHI SHIBAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SHIBAT ATSUSHI BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE. 
#
##############################################################################

__doc__="""Entry"""

def get_rendered_body(body,format):
    """Render body(in stx/restx format) and returns it."""

class Entry:
    """Class for COREBlog entry.
        The features of this class are...
        
        o Information of entry body,extand body,excerpt etc.

        o Comment and trackback, in list of ids.

        o Functions to receive/send trackback.

        o Management interface for comments,trackbacks."""

    def manage_editEntry(self,author,body,extend,excerpt,moderated, \
                    main_category,sub_category=[],title="",subtitle="",  \
                    format = 0, \
                    allow_comment=0,receive_trackback = 0, \
                    trackback_url="",sendnow=0,
                    REQUEST=None,**kw):
        """Edit entry. """

    def index_html(self,ignore_moderation=0,REQUEST=None):
        """Return entry presentation. """

    def body_size(self):
        """Return entry size. """

    def entry_title(self):
        """Return entry title."""
        return self.title

    def entry_url(self):
        """Return the entry url - called permaling"""

    def excerpt_flat(self):
        """Remove cr,lf from excerpt & return it."""

    def get_previous_entry(self):
        """Method to get previous Entry instance."""

    def get_next_entry(self):
        """Method to get next Entry instance."""

    def previous_entry_item(self):
        """Method to get previous entry instance, in list."""

    def next_entry_item(self):
        """Method to get next entry instance, in list."""

    #Comment Management

    def checkCommentValues(self,title,author,body,moderated,email="",url="",REQUEST=None):
        """Check validations of items in comment."""

    def addComment(self,title,author,body,moderated = 1,email="",url="",created="",REQUEST=None):
        """Add a comment, and set cookie if need."""

    def previewComment(self,title,author,body,moderated=1,email="",url="",REQUEST=None):
        """Preview a comment."""

    def forgetPersonalInfo(self,REQUEST=None):
        """Reset cookies for posting comment."""

    def editComment(self,comment_id,title,author,body,email="",url="",REQUEST=None):
        """Edit a comment."""

    def deleteAllComments(self):
        """Delete all comment."""

    def deleteComments(self,ids,REQUEST=None):
        """Delete comments in ids."""

    def deleteComment(self,id):
        """Delete a comment in id."""

    def moderateComments(self,mod_ids=[],REQUEST=None):
        """Chenge moderate setting for comments in mod_ids."""

    def moderateComment(self,id,moderation):
        """Chenge moderate setting for comments."""

    def comment_list(self,consider_moderation = 1):
        """Return list of comment in entry."""

    #Trackback Management

    def addTrackback(self,title,excerpt,url,blog_name,created=""):
        """Add trackback."""

    def editTrackback(self,trackback_id,title,excerpt,url,blog_name,REQUEST=None):
        """Edit a trackback."""

    def deleteAllTrackbacks(self):
        """Delete all trackback in entry."""

    def deleteTrackbacks(self,ids,REQUEST=None):
        """Delete trackback in ids."""

    def deleteTrackback(self,id):
        """Delete a trackback."""

    def moderateTrackbacks(self,mod_ids=[],REQUEST=None):
        """Chenge moderate setting for trackbacks in mod_ids."""

    def moderateTrackback(self,id,moderation):
        """Chenge moderate setting for trackbacks."""

    def trackback_list(self,consider_moderation = 1):
        """Return list of trackback in entry."""

    def tbpingurl(self,REQUEST=None,RESPONSE=None):
        """Return the trackback ping URL"""

    def tbping(self,REQUEST=None,RESPONSE=None):
        """Receive Trackback PING, or show 'mode=rss'"""

    #Category Management

    def entry_category_list(self):
        """Return list of category set for the entry."""

    def set_category(self,cats):
        """Set category."""

    #SendingTrackback management

    def addSendingTrackback(self,url):
        """Add sending trackback."""

    def count_sending_trackback(self):
        """Return count of sending trackback."""

    def sending_trackback_list(self):
        """Return list of sendingTrackbacks."""

    def sendTrackback(self):
        """Send Trackback."""

    def sendPING(self):
        """Send Update nortifications for PING Servers"""
