/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public final class Class
implements Type,
GenericDeclaration,
Serializable {
    private Class() {
    }

    private native void initializeClass();

    protected native void finalize() throws Throwable;

    public static native Class forName(String var0) throws ClassNotFoundException;

    private static Class forName(String string, Class clazz) throws ClassNotFoundException {
        return Class.forName(string, true, clazz.getClassLoaderInternal());
    }

    public static native Class forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Class[] getClasses() {
        this.memberAccessCheck(0);
        return this.internalGetClasses();
    }

    private Class[] internalGetClasses() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Arrays.asList(this.getDeclaredClasses(true)));
        Class clazz = this.getSuperclass();
        if (clazz != null) {
            arrayList.addAll(Arrays.asList(clazz.internalGetClasses()));
        }
        return (Class[])arrayList.toArray(new Class[arrayList.size()]);
    }

    public native ClassLoader getClassLoader();

    private final native ClassLoader getClassLoader(Class var1);

    private native ClassLoader getClassLoaderInternal();

    public native Class getComponentType();

    public native Constructor getConstructor(Class[] var1) throws NoSuchMethodException;

    public Constructor[] getConstructors() {
        this.memberAccessCheck(0);
        return this.getDeclaredConstructors(true);
    }

    public native Constructor getDeclaredConstructor(Class[] var1) throws NoSuchMethodException;

    public Class[] getDeclaredClasses() {
        this.memberAccessCheck(1);
        return this.getDeclaredClasses(false);
    }

    native Class[] getDeclaredClasses(boolean var1);

    public Constructor[] getDeclaredConstructors() {
        this.memberAccessCheck(1);
        return this.getDeclaredConstructors(false);
    }

    native Constructor[] getDeclaredConstructors(boolean var1);

    public native Field getDeclaredField(String var1) throws NoSuchFieldException;

    public Field[] getDeclaredFields() {
        this.memberAccessCheck(1);
        return this.getDeclaredFields(false);
    }

    native Field[] getDeclaredFields(boolean var1);

    private native Method _getDeclaredMethod(String var1, Class[] var2);

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException {
        this.memberAccessCheck(1);
        if ("<init>".equals(string) || "<clinit>".equals(string)) {
            throw new NoSuchMethodException(string);
        }
        Method method = this._getDeclaredMethod(string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method;
    }

    public native Method[] getDeclaredMethods();

    public native Class getDeclaringClass();

    private native Field getField(String var1, int var2) throws NoSuchFieldException;

    public Field getField(String string) throws NoSuchFieldException {
        this.memberAccessCheck(0);
        Field field = this.getField(string, string.hashCode());
        if (field == null) {
            throw new NoSuchFieldException(string);
        }
        return field;
    }

    public Field[] getFields() {
        this.memberAccessCheck(0);
        return this.internalGetFields();
    }

    private Field[] internalGetFields() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(Arrays.asList(this.getDeclaredFields(true)));
        Class[] classArray = this.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            hashSet.addAll(Arrays.asList(classArray[i].internalGetFields()));
        }
        Class clazz = this.getSuperclass();
        if (clazz != null) {
            hashSet.addAll(Arrays.asList(clazz.internalGetFields()));
        }
        return (Field[])hashSet.toArray(new Field[hashSet.size()]);
    }

    public Package getPackage() {
        ClassLoader classLoader = this.getClassLoaderInternal();
        if (classLoader != null) {
            return classLoader.getPackage(Class.getPackagePortion(this.getName()));
        }
        return VMClassLoader.getPackage(Class.getPackagePortion(this.getName()));
    }

    public native Class[] getInterfaces();

    private final native void getSignature(StringBuffer var1);

    private static final native String getSignature(Class[] var0, boolean var1);

    public native Method _getMethod(String var1, Class[] var2);

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException {
        this.memberAccessCheck(0);
        if ("<init>".equals(string) || "<clinit>".equals(string)) {
            throw new NoSuchMethodException(string);
        }
        Method method = this._getMethod(string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method;
    }

    private native int _getMethods(Method[] var1, int var2);

    public native Method[] getMethods();

    public native int getModifiers();

    public native String getName();

    public URL getResource(String string) {
        String string2 = this.resourcePath(string);
        ClassLoader classLoader = this.getClassLoaderInternal();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string2);
        }
        return classLoader.getResource(string2);
    }

    public InputStream getResourceAsStream(String string) {
        String string2 = this.resourcePath(string);
        ClassLoader classLoader = this.getClassLoaderInternal();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return classLoader.getResourceAsStream(string2);
    }

    private String resourcePath(String string) {
        if (string.length() > 0) {
            if (string.charAt(0) != '/') {
                String string2 = Class.getPackagePortion(this.getName());
                if (string2.length() > 0) {
                    string = string2.replace('.', '/') + '/' + string;
                }
            } else {
                string = string.substring(1);
            }
        }
        return string;
    }

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public native Object newInstance() throws InstantiationException, IllegalAccessException;

    private native ProtectionDomain getProtectionDomain0();

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(VMClassLoader.protectionDomainPermission);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            return VMClassLoader.unknownProtectionDomain;
        }
        return protectionDomain;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public boolean desiredAssertionStatus() {
        ClassLoader classLoader;
        block20: {
            Object object;
            block19: {
                ClassLoader classLoader2;
                block18: {
                    block17: {
                        classLoader = this.getClassLoaderInternal();
                        if (classLoader == null) {
                            return VMClassLoader.defaultAssertionStatus();
                        }
                        if (classLoader.classAssertionStatus == null) break block17;
                        ClassLoader classLoader3 = classLoader;
                        synchronized (classLoader3) {
                            block15: {
                                try {
                                    object = classLoader.classAssertionStatus.get(this.getName());
                                    if (object == null) break block15;
                                    boolean bl = object.equals(Boolean.TRUE);
                                    Object var5_9 = null;
                                    return bl;
                                }
                                catch (Throwable throwable) {
                                    Object var5_11 = null;
                                    throw throwable;
                                }
                            }
                            classLoader2 = null;
                            break block18;
                        }
                    }
                    object = ClassLoader.systemClassAssertionStatus.get(this.getName());
                    if (object != null) {
                        boolean bl = object.equals(Boolean.TRUE);
                        return bl;
                    }
                }
                if (classLoader.packageAssertionStatus == null) break block19;
                classLoader2 = classLoader;
                synchronized (classLoader2) {
                    block16: {
                        try {
                            String string = Class.getPackagePortion(this.getName());
                            if ("".equals(string)) {
                                object = classLoader.packageAssertionStatus.get(null);
                            } else {
                                do {
                                    object = classLoader.packageAssertionStatus.get(string);
                                } while (!"".equals(string = Class.getPackagePortion(string)) && object == null);
                            }
                            if (object == null) break block16;
                            boolean bl = object.equals(Boolean.TRUE);
                            Object var7_14 = null;
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var7_16 = null;
                            throw throwable;
                        }
                    }
                    Object var7_15 = null;
                    break block20;
                }
            }
            String string = Class.getPackagePortion(this.getName());
            if ("".equals(string)) {
                object = ClassLoader.systemPackageAssertionStatus.get(null);
            } else {
                do {
                    object = ClassLoader.systemPackageAssertionStatus.get(string);
                } while (!"".equals(string = Class.getPackagePortion(string)) && object == null);
            }
            if (object != null) {
                boolean bl = object.equals(Boolean.TRUE);
                return bl;
            }
        }
        boolean bl = classLoader.defaultAssertionStatus;
        return bl;
    }

    private static String getPackagePortion(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private void memberAccessCheck(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, n);
            Package package_ = this.getPackage();
            if (package_ != null) {
                securityManager.checkPackageAccess(package_.getName());
            }
        }
    }

    public String getSimpleName() {
        return "";
    }

    public Class getEnclosingClass() {
        return null;
    }

    public Constructor getEnclosingConstructor() {
        return null;
    }

    public Method getEnclosingMethod() {
        return null;
    }

    public TypeVariable[] getTypeParameters() {
        return new TypeVariable[0];
    }

    public boolean isEnum() {
        return false;
    }
}

