#!/usr/local/bin/python2.7

''' proxy on remote node for remote python call
'''

__copyright__='''
Author: Huang Zhen <zhenhltc@cn.ibm.com>
Copyright (C) 2005 International Business Machines
'''

#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#


import sys, pickle, base64, binascii

# check the number of arguments
if len(sys.argv) != 4 :
        print "usage %s module function args"%sys.argv[0]
        sys.exit(1)

# import the module        
try :
        module = __import__(sys.argv[1], globals(), locals(), [])
except ImportError:
        print "can not find module %s"%sys.argv[1]
        sys.exit(1)

# find the function
try :
        func = getattr(module,sys.argv[2])
except        AttributeError:
        print "can not find function %s"%sys.argv[2]
        sys.exit(1)

# unpack the arguments of functions
try :
        args = pickle.loads(binascii.a2b_base64(sys.argv[3]))
except  IndexError:
        print "can not unpickle args %s"%sys.argv[3]
        sys.exit(1)
        
# call the function and return packed result
try :
        result = apply(func,args)
        print binascii.b2a_base64(pickle.dumps(result))
        sys.exit(0)
except TypeError:
        print "parameter error"
        sys.exit(1)
