/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.PolicyNodeImpl;
import gnu.java.security.x509.X509CRLSelectorImpl;
import gnu.java.security.x509.X509CertSelectorImpl;
import gnu.java.security.x509.ext.BasicConstraints;
import gnu.java.security.x509.ext.CertificatePolicies;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.PolicyConstraint;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PKIXCertPathValidatorImpl
extends CertPathValidatorSpi {
    private static final boolean DEBUG = false;
    public static final String ANY_POLICY = "2.5.29.32.0";

    private static final void debug(String string) {
        System.err.print(">> PKIXCertPathValidatorImpl: ");
        System.err.println(string);
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        Object object3;
        LinkedList linkedList;
        List list2;
        X509CRLSelectorImpl x509CRLSelectorImpl;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Set set;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("not a PKIXParameters object");
        }
        PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl();
        Set set2 = ((PKIXParameters)certPathParameters).getInitialPolicies();
        policyNodeImpl.setValidPolicy(ANY_POLICY);
        policyNodeImpl.setCritical(false);
        policyNodeImpl.setDepth(0);
        if (set2 != null) {
            policyNodeImpl.addAllExpectedPolicies(set2);
        } else {
            policyNodeImpl.addExpectedPolicy(ANY_POLICY);
        }
        List list3 = ((PKIXParameters)certPathParameters).getCertPathCheckers();
        List list4 = certPath.getCertificates();
        if (list4 == null || list4.size() == 0) {
            throw new CertPathValidatorException();
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = (X509Certificate[])list4.toArray(new X509Certificate[list4.size()]);
        }
        catch (ClassCastException classCastException) {
            throw new CertPathValidatorException("invalid certificate path");
        }
        String string = ((PKIXParameters)certPathParameters).getSigProvider();
        Object object8 = null;
        Date date = ((PKIXParameters)certPathParameters).getDate();
        if (date == null) {
            date = new Date();
        }
        LinkedList linkedList2 = new LinkedList();
        int n = x509CertificateArray.length - 1;
        while (n >= 0) {
            try {
                x509CertificateArray[n].checkValidity(date);
            }
            catch (CertificateException certificateException) {
                throw new CertPathValidatorException(certificateException.toString());
            }
            set = PKIXCertPathValidatorImpl.getCritExts(x509CertificateArray[n]);
            object7 = list3.iterator();
            while (object7.hasNext()) {
                try {
                    ((PKIXCertPathChecker)object7.next()).check(x509CertificateArray[n], set);
                }
                catch (Exception exception) {}
            }
            object7 = null;
            if (x509CertificateArray[n] instanceof GnuPKIExtension) {
                object6 = ((GnuPKIExtension)((Object)x509CertificateArray[n])).getExtension(PolicyConstraint.ID);
                if (object6 != null) {
                    object7 = (PolicyConstraint)((Extension)object6).getValue();
                }
            } else {
                object6 = x509CertificateArray[n].getExtensionValue(PolicyConstraint.ID.toString());
                if (object6 != null) {
                    try {
                        object7 = new PolicyConstraint((byte[])object6);
                    }
                    catch (Exception exception) {}
                }
            }
            if (object7 != null && ((PolicyConstraint)object7).getRequireExplicitPolicy() >= 0) {
                linkedList2.add(new int[]{x509CertificateArray.length - n, ((PolicyConstraint)object7).getRequireExplicitPolicy()});
            }
            PKIXCertPathValidatorImpl.updatePolicyTree(x509CertificateArray[n], policyNodeImpl, x509CertificateArray.length - n, (PKIXParameters)certPathParameters, this.checkExplicitPolicy(x509CertificateArray.length - n, linkedList2));
            if (n == 0) break;
            PKIXCertPathValidatorImpl.basicSanity(x509CertificateArray, n);
            object6 = null;
            try {
                object6 = x509CertificateArray[n].getPublicKey();
                if (object6 instanceof DSAPublicKey && ((object5 = ((DSAPublicKey)object6).getParams()) == null || object5.getP() == null || object5.getG() == null || object5.getQ() == null)) {
                    if (object8 == null) {
                        throw new InvalidKeyException("DSA keys not chainable");
                    }
                    if (!(object8 instanceof DSAPublicKey)) {
                        throw new InvalidKeyException("DSA keys not chainable");
                    }
                    object5 = ((DSAPublicKey)object8).getParams();
                    object6 = new DSSPublicKey(2, object5.getP(), object5.getQ(), object5.getG(), ((DSAPublicKey)object6).getY());
                }
                if (string == null) {
                    x509CertificateArray[n - 1].verify((PublicKey)object6);
                } else {
                    x509CertificateArray[n - 1].verify((PublicKey)object6, string);
                }
                object8 = object6;
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception.toString());
            }
            if (!x509CertificateArray[n].getSubjectDN().equals(x509CertificateArray[n - 1].getIssuerDN())) {
                throw new CertPathValidatorException("issuer DN mismatch");
            }
            object5 = x509CertificateArray[n - 1].getIssuerUniqueID();
            object4 = x509CertificateArray[n].getSubjectUniqueID();
            if (object5 != null && object4 != null && !Arrays.equals((boolean[])object5, (boolean[])object4)) {
                throw new CertPathValidatorException("UID mismatch");
            }
            if (((PKIXParameters)certPathParameters).isRevocationEnabled()) {
                x509CRLSelectorImpl = new X509CRLSelectorImpl();
                try {
                    x509CRLSelectorImpl.addIssuerName(x509CertificateArray[n].getSubjectDN());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("error selecting CRLs");
                }
                list2 = ((PKIXParameters)certPathParameters).getCertStores();
                linkedList = new LinkedList();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    object3 = (CertStore)iterator.next();
                    try {
                        object2 = ((CertStore)object3).getCRLs(x509CRLSelectorImpl);
                        linkedList.addAll((Collection)object2);
                    }
                    catch (CertStoreException certStoreException) {}
                }
                if (linkedList.isEmpty()) {
                    throw new CertPathValidatorException("no CRLs for issuer");
                }
                boolean bl = false;
                object3 = linkedList.iterator();
                while (object3.hasNext()) {
                    object2 = (CRL)object3.next();
                    if (!(object2 instanceof X509CRL) || !PKIXCertPathValidatorImpl.checkCRL((X509CRL)(object = (X509CRL)object2), x509CertificateArray, date, x509CertificateArray[n], (PublicKey)object6, list2)) continue;
                    if (((CRL)object).isRevoked(x509CertificateArray[n - 1])) {
                        throw new CertPathValidatorException("certificate is revoked");
                    }
                    bl = true;
                }
                if (!bl) {
                    throw new CertPathValidatorException("certificate's validity could not be determined");
                }
            }
            --n;
        }
        policyNodeImpl.setReadOnly();
        Exception exception = null;
        set = ((PKIXParameters)certPathParameters).getTrustAnchors();
        object7 = set.iterator();
        while (object7.hasNext()) {
            object6 = (TrustAnchor)object7.next();
            object5 = null;
            object4 = null;
            if (((TrustAnchor)object6).getTrustedCert() != null) {
                object5 = ((TrustAnchor)object6).getTrustedCert();
                object4 = ((Certificate)object5).getPublicKey();
            } else {
                object4 = ((TrustAnchor)object6).getCAPublicKey();
            }
            if (object4 == null) continue;
            try {
                if (object5 != null) {
                    ((X509Certificate)object5).checkValidity(date);
                }
                x509CertificateArray[x509CertificateArray.length - 1].verify((PublicKey)object4);
                if (object5 != null && ((X509Certificate)object5).getBasicConstraints() >= 0 && ((X509Certificate)object5).getBasicConstraints() < x509CertificateArray.length) continue;
                if (((PKIXParameters)certPathParameters).isRevocationEnabled()) {
                    x509CRLSelectorImpl = new X509CRLSelectorImpl();
                    if (object5 != null) {
                        try {
                            x509CRLSelectorImpl.addIssuerName(((X509Certificate)object5).getSubjectDN());
                        }
                        catch (IOException iOException) {}
                    } else {
                        x509CRLSelectorImpl.addIssuerName(((TrustAnchor)object6).getCAName());
                    }
                    list2 = ((PKIXParameters)certPathParameters).getCertStores();
                    linkedList = new LinkedList();
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        object3 = (CertStore)iterator.next();
                        try {
                            object2 = ((CertStore)object3).getCRLs(x509CRLSelectorImpl);
                            linkedList.addAll((Collection)object2);
                        }
                        catch (CertStoreException certStoreException) {}
                    }
                    if (linkedList.isEmpty()) continue;
                    iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        object3 = (CRL)iterator.next();
                        if (!(object3 instanceof X509CRL)) continue;
                        object2 = (X509CRL)object3;
                        try {
                            ((X509CRL)object2).verify((PublicKey)object4);
                        }
                        catch (Exception exception2) {
                            continue;
                        }
                        object = ((X509CRL)object2).getNextUpdate();
                        if (object != null && ((Date)object).compareTo(date) < 0 || !((CRL)object2).isRevoked(x509CertificateArray[x509CertificateArray.length - 1])) continue;
                        throw new CertPathValidatorException("certificate is revoked");
                    }
                }
                return new PKIXCertPathValidatorResult((TrustAnchor)object6, policyNodeImpl, x509CertificateArray[0].getPublicKey());
            }
            catch (Exception exception3) {
                exception = exception3;
            }
        }
        object7 = new CertPathValidatorException("path validation failed");
        if (exception != null) {
            ((Throwable)object7).initCause(exception);
        }
        throw object7;
    }

    private static final boolean checkCRL(X509CRL x509CRL, X509Certificate[] x509CertificateArray, Date date, X509Certificate x509Certificate, PublicKey publicKey, List list2) {
        Object object;
        Date date2 = x509CRL.getNextUpdate();
        if (date2 != null && date2.compareTo(date) < 0) {
            return false;
        }
        if (x509CRL.hasUnsupportedCriticalExtension()) {
            return false;
        }
        int n = 0;
        while (n < x509CertificateArray.length) {
            if (x509CertificateArray[n].getSubjectDN().equals(x509CRL.getIssuerDN()) && ((object = x509CertificateArray[n].getKeyUsage()) == null || object[6])) {
                try {
                    x509CRL.verify(x509CertificateArray[n].getPublicKey());
                    return true;
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        if (x509CRL.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
            try {
                boolean[] blArray = x509Certificate.getKeyUsage();
                if (blArray != null && !blArray[6]) {
                    throw new Exception();
                }
                x509CRL.verify(publicKey);
                return true;
            }
            catch (Exception exception) {}
        }
        try {
            Object object2;
            X509CertSelectorImpl x509CertSelectorImpl = new X509CertSelectorImpl();
            x509CertSelectorImpl.addSubjectName(x509CRL.getIssuerDN());
            object = new LinkedList();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object2 = (CertStore)iterator.next();
                try {
                    object.addAll(((CertStore)object2).getCertificates(x509CertSelectorImpl));
                }
                catch (CertStoreException certStoreException) {}
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (X509Certificate)iterator.next();
                int n2 = 0;
                while (n2 < x509CertificateArray.length) {
                    boolean[] blArray;
                    if (((X509Certificate)object2).getIssuerDN().equals(x509CertificateArray[n2].getSubjectDN()) && ((blArray = ((X509Certificate)object2).getKeyUsage()) == null || blArray[6])) {
                        try {
                            ((Certificate)object2).verify(x509CertificateArray[n2].getPublicKey());
                            x509CRL.verify(((Certificate)object2).getPublicKey());
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
                if (!((X509Certificate)object2).getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
                ((Certificate)object2).verify(publicKey);
                x509CRL.verify(((Certificate)object2).getPublicKey());
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private static final Set getCritExts(X509Certificate x509Certificate) {
        HashSet hashSet = new HashSet();
        if (x509Certificate instanceof GnuPKIExtension) {
            Collection collection = ((GnuPKIExtension)((Object)x509Certificate)).getExtensions();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Extension extension = (Extension)iterator.next();
                if (!extension.isCritical() || extension.isSupported()) continue;
                hashSet.add(extension.getOid().toString());
            }
        } else {
            hashSet.addAll(x509Certificate.getCriticalExtensionOIDs());
        }
        return hashSet;
    }

    private static final void basicSanity(X509Certificate[] x509CertificateArray, int n) throws CertPathValidatorException {
        X509Certificate x509Certificate = x509CertificateArray[n];
        int n2 = 0;
        int n3 = n - 1;
        while (n3 > 0) {
            if (!x509CertificateArray[n3].getIssuerDN().equals(x509CertificateArray[n3].getSubjectDN())) {
                ++n2;
            }
            --n3;
        }
        Extension extension = null;
        if (x509Certificate instanceof GnuPKIExtension) {
            extension = ((GnuPKIExtension)((Object)x509Certificate)).getExtension(BasicConstraints.ID);
        } else {
            try {
                extension = new Extension(x509Certificate.getExtensionValue(BasicConstraints.ID.toString()));
            }
            catch (Exception exception) {}
        }
        if (extension == null) {
            throw new CertPathValidatorException("no basicConstraints");
        }
        BasicConstraints basicConstraints = (BasicConstraints)extension.getValue();
        if (!basicConstraints.isCA()) {
            throw new CertPathValidatorException("certificate cannot be used to verify signatures");
        }
        if (basicConstraints.getPathLengthConstraint() >= 0 && basicConstraints.getPathLengthConstraint() < n2) {
            throw new CertPathValidatorException("path is too long");
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && !blArray[5]) {
            throw new CertPathValidatorException("certificate cannot be used to sign certificates");
        }
    }

    private static final void updatePolicyTree(X509Certificate x509Certificate, PolicyNodeImpl policyNodeImpl, int n, PKIXParameters pKIXParameters, boolean bl) throws CertPathValidatorException {
        Object object;
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = null;
        linkedList.addLast(Collections.singleton(policyNodeImpl).iterator());
        do {
            iterator = (Iterator)linkedList.removeLast();
            while (iterator.hasNext()) {
                object = (PolicyNodeImpl)iterator.next();
                if (((PolicyNodeImpl)object).getDepth() == n - 1) {
                    hashSet.add(object);
                    continue;
                }
                linkedList.addLast(iterator);
                iterator = ((PolicyNodeImpl)object).getChildren();
            }
        } while (!linkedList.isEmpty());
        object = null;
        CertificatePolicies certificatePolicies = null;
        Object var10_10 = null;
        if (x509Certificate instanceof GnuPKIExtension && (object = ((GnuPKIExtension)((Object)x509Certificate)).getExtension(CertificatePolicies.ID)) != null) {
            certificatePolicies = (CertificatePolicies)((Extension)object).getValue();
        }
        List list2 = null;
        list2 = certificatePolicies != null ? certificatePolicies.getPolicies() : Collections.EMPTY_LIST;
        boolean bl2 = false;
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)iterator2.next();
            Iterator iterator3 = list2.iterator();
            while (iterator3.hasNext()) {
                List list3;
                OID oID = (OID)iterator3.next();
                if (oID.toString().equals(ANY_POLICY) && pKIXParameters.isAnyPolicyInhibited()) continue;
                PolicyNodeImpl policyNodeImpl3 = new PolicyNodeImpl();
                policyNodeImpl3.setValidPolicy(oID.toString());
                policyNodeImpl3.addExpectedPolicy(oID.toString());
                if (policyNodeImpl2.getExpectedPolicies().contains(oID.toString())) {
                    policyNodeImpl2.addChild(policyNodeImpl3);
                    bl2 = true;
                } else if (policyNodeImpl2.getExpectedPolicies().contains(ANY_POLICY)) {
                    policyNodeImpl2.addChild(policyNodeImpl3);
                    bl2 = true;
                } else if (ANY_POLICY.equals(oID.toString())) {
                    policyNodeImpl2.addChild(policyNodeImpl3);
                    bl2 = true;
                }
                if (!bl2 || certificatePolicies == null || (list3 = certificatePolicies.getPolicyQualifierInfos(oID)) == null) continue;
                policyNodeImpl3.addAllPolicyQualifiers(list3);
            }
        }
        if (!bl2 && (pKIXParameters.isExplicitPolicyRequired() || bl)) {
            throw new CertPathValidatorException("policy tree building failed");
        }
    }

    private final boolean checkExplicitPolicy(int n, List list2) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            int n2;
            int[] nArray = (int[])iterator.next();
            int n3 = nArray[0];
            if (n - n3 < (n2 = nArray[1])) continue;
            return true;
        }
        return false;
    }
}

