/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.StaticTrustAnchors;
import gnu.javax.net.ssl.provider.SSLServerSocketFactory;
import gnu.javax.net.ssl.provider.SSLSocketFactory;
import gnu.javax.net.ssl.provider.SessionContext;
import gnu.javax.net.ssl.provider.Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Context
extends SSLContextSpi {
    private SessionContext clientSessions;
    private SessionContext serverSessions;
    private X509KeyManager keyManager;
    private X509TrustManager trustManager;
    private SRPTrustManager srpTrustManager;
    private SecureRandom random;
    static /* synthetic */ Class class$gnu$javax$net$ssl$provider$Context;

    protected final SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessions;
    }

    protected final SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessions;
    }

    protected final javax.net.ssl.SSLServerSocketFactory engineGetServerSocketFactory() {
        if (this.keyManager == null || this.trustManager == null && this.srpTrustManager == null || this.random == null) {
            throw new IllegalStateException();
        }
        return new SSLServerSocketFactory(this.trustManager, this.srpTrustManager, this.keyManager, this.random, this.serverSessions);
    }

    protected final javax.net.ssl.SSLSocketFactory engineGetSocketFactory() {
        if (this.keyManager == null || this.trustManager == null || this.random == null) {
            throw new IllegalStateException();
        }
        return new SSLSocketFactory(this.trustManager, this.keyManager, this.random, this.clientSessions);
    }

    protected final void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        int n;
        this.keyManager = null;
        this.trustManager = null;
        this.srpTrustManager = null;
        if (keyManagerArray != null) {
            n = 0;
            while (n < keyManagerArray.length) {
                if (keyManagerArray[n] instanceof X509KeyManager) {
                    this.keyManager = (X509KeyManager)keyManagerArray[n];
                    break;
                }
                ++n;
            }
        }
        if (this.keyManager == null) {
            this.keyManager = this.defaultKeyManager();
        }
        if (trustManagerArray != null) {
            n = 0;
            while (n < trustManagerArray.length) {
                if (trustManagerArray[n] instanceof X509TrustManager) {
                    if (this.trustManager == null) {
                        this.trustManager = (X509TrustManager)trustManagerArray[n];
                    }
                } else if (trustManagerArray[n] instanceof SRPTrustManager && this.srpTrustManager == null) {
                    this.srpTrustManager = (SRPTrustManager)trustManagerArray[n];
                }
                ++n;
            }
        }
        if (this.trustManager == null && this.srpTrustManager == null) {
            this.trustManager = this.defaultTrustManager();
        }
        this.random = secureRandom != null ? secureRandom : this.defaultRandom();
    }

    private final X509KeyManager defaultKeyManager() throws KeyManagementException {
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("JessieX509", "Jessie");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagementException();
        }
        try {
            keyManagerFactory.init(null, null);
            return (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            keyManagerFactory.init(new NullManagerParameters());
            return (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
    }

    private final X509TrustManager defaultTrustManager() throws KeyManagementException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("JessieX509", "Jessie");
            trustManagerFactory.init(StaticTrustAnchors.CA_CERTS);
            return (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagementException(noSuchProviderException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new KeyManagementException(invalidAlgorithmParameterException.toString());
        }
    }

    private final SecureRandom defaultRandom() throws KeyManagementException {
        String string = Util.getSecurityProperty("jessie.secure.random");
        if (string == null) {
            string = "Fortuna";
        }
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(noSuchAlgorithmException.toString());
        }
        return secureRandom;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Context() {
        ClassLoader classLoader;
        String string = Util.getSecurityProperty("jessie.clientSessionContext.codec");
        String string2 = null;
        if (string == null) {
            string = "null";
        }
        if (string.equalsIgnoreCase("xml")) {
            string2 = "gnu.javax.net.ssl.provider.XMLSessionContext";
        } else if (string.equalsIgnoreCase("jdbc")) {
            string2 = "gnu.javax.net.ssl.provider.JDBCSessionContext";
        } else if (string.equalsIgnoreCase("null")) {
            string2 = "gnu.javax.net.ssl.provider.SessionContext";
        } else {
            throw new IllegalArgumentException("no such codec: " + string);
        }
        try {
            Class clazz = class$gnu$javax$net$ssl$provider$Context;
            if (clazz == null) {
                clazz = class$gnu$javax$net$ssl$provider$Context = Context.class("[Lgnu.javax.net.ssl.provider.Context;", false);
            }
            if ((classLoader = clazz.getClassLoader()) == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            this.clientSessions = (SessionContext)classLoader.loadClass(string2).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException(exception.toString());
        }
        string = Util.getSecurityProperty("jessie.serverSessionContext.codec");
        if (string == null) {
            string = "null";
        }
        if (string.equalsIgnoreCase("xml")) {
            string2 = "gnu.javax.net.ssl.provider.XMLSessionContext";
        } else if (string.equalsIgnoreCase("jdbc")) {
            string2 = "gnu.javax.net.ssl.provider.JDBCSessionContext";
        } else if (string.equalsIgnoreCase("null")) {
            string2 = "gnu.javax.net.ssl.provider.SessionContext";
        } else {
            throw new IllegalArgumentException("no such codec: " + string);
        }
        try {
            Class clazz = class$gnu$javax$net$ssl$provider$Context;
            if (clazz == null) {
                clazz = class$gnu$javax$net$ssl$provider$Context = Context.class("[Lgnu.javax.net.ssl.provider.Context;", false);
            }
            if ((classLoader = clazz.getClassLoader()) == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            this.serverSessions = (SessionContext)classLoader.loadClass(string2).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException(exception.toString());
        }
    }
}

