/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import java.io.IOException;
import java.io.Reader;

public class UnicodeReader {
    final Reader in;

    public void mark(int n) throws IOException {
        this.in.mark(n * 2);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return n;
        }
        if (n >= 55296 && n < 56320) {
            int n2 = this.in.read();
            if (n2 < 56320) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(n));
            if (n2 >= 57344) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(n));
            return Character.toCodePoint((char)n, (char)n2);
        }
        if (n < 56320) return n;
        if (n >= 57344) return n;
        throw new IOException("unpaired surrogate: U+" + Integer.toHexString(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(int[] nArray, int n, int n2) throws IOException {
        int n3;
        char c;
        if (n2 == 0) {
            return 0;
        }
        char[] cArray = new char[n2];
        int n4 = this.in.read(cArray, 0, n2);
        if (n4 <= 0) {
            return n4;
        }
        int n5 = n4 - 1;
        int n6 = 0;
        int n7 = n;
        while (n6 < n5) {
            c = cArray[n6];
            if (c >= '\ud800' && c < '\udc00') {
                n3 = cArray[n6 + 1];
                if (n3 < 56320 || n3 >= 57344) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                nArray[n7++] = Character.toCodePoint(c, (char)n3);
                ++n6;
            } else {
                if (c >= '\udc00' && c < '\ue000') {
                    throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                }
                nArray[n7++] = c;
            }
            ++n6;
        }
        if (n6 != n5) return n7;
        c = cArray[n5];
        if (c >= '\ud800' && c < '\udc00') {
            n3 = this.in.read();
            if (n3 < 56320 || n3 >= 57344) throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
            nArray[n7++] = Character.toCodePoint(c, (char)n3);
            return n7;
        }
        if (c >= '\udc00' && c < '\ue000') {
            throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
        }
        nArray[n7++] = c;
        return n7;
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] toCodePointArray(String string) throws IOException {
        char[] cArray = string.toCharArray();
        int[] nArray = new int[cArray.length];
        if (cArray.length <= 0) return nArray;
        int n = cArray.length - 1;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '\ud800' && c < '\udc00') {
                char c2 = cArray[n2 + 1];
                if (c2 < '\udc00') throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                if (c2 >= '\ue000') throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                nArray[n3++] = Character.toCodePoint(c, c2);
                ++n2;
            } else {
                if (c >= '\udc00' && c < '\ue000') {
                    throw new IOException("unpaired surrogate: U+" + Integer.toHexString(c));
                }
                nArray[n3++] = c;
            }
            ++n2;
        }
        if (n2 != n) return nArray;
        nArray[n3++] = cArray[n];
        if (n3 >= nArray.length) return nArray;
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    UnicodeReader(Reader reader) {
        this.in = reader;
    }
}

