/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HTMLDocument
extends DefaultStyledDocument {
    public static final String AdditionalComments = "AdditionalComments";
    URL baseURL;
    boolean preservesUnknownTags;
    int tokenThreshold;
    HTMLEditorKit.Parser parser;
    StyleSheet styleSheet;
    AbstractDocument.Content content;

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    protected void create(DefaultStyledDocument.ElementSpec[] elementSpecArray) {
        super.create(elementSpecArray);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.AttributeContext attributeContext = this.getAttributeContext();
        AttributeSet attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.HTML);
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, attributeSet);
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.BODY);
        AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)this.createBranchElement(branchElement, attributeSet);
        branchElement.replace(0, 0, new Element[]{branchElement2});
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.P);
        AbstractDocument.BranchElement branchElement3 = (AbstractDocument.BranchElement)this.createBranchElement(branchElement2, attributeSet);
        branchElement2.replace(0, 0, new Element[]{branchElement3});
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        Element element = this.createLeafElement(branchElement3, attributeSet, 0, 1);
        branchElement3.replace(0, 0, new Element[]{element});
        return branchElement;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        RunElement runElement = new RunElement(element, attributeSet, n, n2);
        runElement.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        return new RunElement(element, attributeSet, n, n2);
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(element, attributeSet);
    }

    protected void insert(int n, DefaultStyledDocument.ElementSpec[] elementSpecArray) throws BadLocationException {
        super.insert(n, elementSpecArray);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        System.out.println("insertUpdate not implemented");
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    public HTMLEditorKit.Parser getParser() {
        return this.parser;
    }

    public void setParser(HTMLEditorKit.Parser parser) {
        this.parser = parser;
    }

    public void setTokenThreshold(int n) {
        this.tokenThreshold = n;
    }

    public int getTokenThreshold() {
        return this.tokenThreshold;
    }

    public URL getBase() {
        return this.baseURL;
    }

    public void setBase(URL uRL) {
        this.baseURL = uRL;
        this.styleSheet.setBase(uRL);
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void setPreservesUnknownTags(boolean bl) {
        this.preservesUnknownTags = bl;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
    }

    public Iterator getIterator(HTML.Tag tag) {
        return new LeafIterator(tag, this);
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        return new HTMLReader(n);
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        return new HTMLReader(n, n2, n3, tag);
    }

    public Element getElement(Element element, Object object, Object object2) {
        if (element != null) {
            if (element.getAttributes().containsAttribute(object, object2)) {
                return element;
            }
            int n = element.getElementCount();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = element.getElement(n2);
                if (element2.getAttributes().containsAttribute(object, object2)) {
                    return element2;
                }
                Element element3 = this.getElement(element2, object, object2);
                if (element3 != null) {
                    return element3;
                }
                ++n2;
            }
        }
        return null;
    }

    public Element getElement(String string) {
        Element element = this.getDefaultRootElement();
        return this.getElement(element, HTML.getAttributeKey(string), string);
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
        if (element.isLeaf()) {
            throw new IllegalArgumentException("Element is a leaf");
        }
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        System.out.println("setInnerHTML not implemented");
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        System.out.println("setOuterHTML not implemented");
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        System.out.println("insertBeforeStart not implemented");
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        System.out.println("insertBeforeEnd not implemented");
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        System.out.println("insertAfterEnd not implemented");
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        System.out.println("insertAfterStart not implemented");
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        System.out.println("setParagraphAttributes not implemented");
        super.setParagraphAttributes(n, n2, attributeSet, bl);
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        System.out.println("fireChangedUpdate not implemented");
        super.fireChangedUpdate(documentEvent);
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        super.fireUndoableEditUpdate(undoableEditEvent);
    }

    private final /* synthetic */ void this() {
        this.baseURL = null;
        this.preservesUnknownTags = true;
        this.tokenThreshold = Integer.MAX_VALUE;
    }

    public HTMLDocument() {
        this((StyleSheet)null);
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        this.this();
        this.content = content;
        if (styleSheet == null) {
            styleSheet = new StyleSheet();
            styleSheet.importStyleSheet(this.getClass().getResource("default.css"));
        }
        this.styleSheet = styleSheet;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RunElement
    extends AbstractDocument.LeafElement {
        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            return string;
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public RunElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(HTMLDocument.this, element, attributeSet, n, n2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BlockElement
    extends AbstractDocument.BranchElement {
        public AttributeSet getResolveParent() {
            return null;
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            return string;
        }

        public BlockElement(Element element, AttributeSet attributeSet) {
            super(HTMLDocument.this, element, attributeSet);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LeafIterator
    extends Iterator {
        HTML.Tag tag;
        HTMLDocument doc;
        ElementIterator it;

        public AttributeSet getAttributes() {
            if (this.it.current() != null) {
                return this.it.current().getAttributes();
            }
            return null;
        }

        public int getEndOffset() {
            if (this.it.current() != null) {
                return this.it.current().getEndOffset();
            }
            return -1;
        }

        public int getStartOffset() {
            if (this.it.current() != null) {
                return this.it.current().getStartOffset();
            }
            return -1;
        }

        public void next() {
            this.it.next();
            while (this.it.current() != null && !this.it.current().isLeaf()) {
                this.it.next();
            }
        }

        public boolean isValid() {
            boolean bl = false;
            if (this.it.current() != null) {
                bl = true;
            }
            return bl;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        public LeafIterator(HTML.Tag tag, HTMLDocument hTMLDocument2) {
            this.doc = hTMLDocument2;
            this.tag = tag;
            this.it = new ElementIterator(this.doc);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        protected MutableAttributeSet charAttr;
        protected Vector parseBuffer;
        Stack charAttrStack;
        private Stack parseStack;
        HashMap tagToAction;
        boolean endHTMLEncountered;
        int popDepth;
        int pushDepth;
        int offset;
        HTML.Tag insertTag;
        boolean insertTagEncountered;
        boolean debug;

        void print(String string) {
            if (this.debug) {
                System.out.println(string);
            }
        }

        void initTags() {
            this.tagToAction = new HashMap(72);
            CharacterAction characterAction = new CharacterAction();
            HiddenAction hiddenAction = new HiddenAction();
            AreaAction areaAction = new AreaAction();
            BaseAction baseAction = new BaseAction();
            BlockAction blockAction = new BlockAction();
            SpecialAction specialAction = new SpecialAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            HeadAction headAction = new HeadAction();
            FormAction formAction = new FormAction();
            IsindexAction isindexAction = new IsindexAction();
            LinkAction linkAction = new LinkAction();
            MapAction mapAction = new MapAction();
            PreAction preAction = new PreAction();
            MetaAction metaAction = new MetaAction();
            StyleAction styleAction = new StyleAction();
            TitleAction titleAction = new TitleAction();
            this.tagToAction.put(HTML.Tag.A, characterAction);
            this.tagToAction.put(HTML.Tag.ADDRESS, characterAction);
            this.tagToAction.put(HTML.Tag.APPLET, hiddenAction);
            this.tagToAction.put(HTML.Tag.AREA, areaAction);
            this.tagToAction.put(HTML.Tag.B, characterAction);
            this.tagToAction.put(HTML.Tag.BASE, baseAction);
            this.tagToAction.put(HTML.Tag.BASEFONT, characterAction);
            this.tagToAction.put(HTML.Tag.BIG, characterAction);
            this.tagToAction.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagToAction.put(HTML.Tag.BODY, blockAction);
            this.tagToAction.put(HTML.Tag.BR, specialAction);
            this.tagToAction.put(HTML.Tag.CAPTION, blockAction);
            this.tagToAction.put(HTML.Tag.CENTER, blockAction);
            this.tagToAction.put(HTML.Tag.CITE, characterAction);
            this.tagToAction.put(HTML.Tag.CODE, characterAction);
            this.tagToAction.put(HTML.Tag.DD, blockAction);
            this.tagToAction.put(HTML.Tag.DFN, characterAction);
            this.tagToAction.put(HTML.Tag.DIR, blockAction);
            this.tagToAction.put(HTML.Tag.DIV, blockAction);
            this.tagToAction.put(HTML.Tag.DL, blockAction);
            this.tagToAction.put(HTML.Tag.DT, paragraphAction);
            this.tagToAction.put(HTML.Tag.EM, characterAction);
            this.tagToAction.put(HTML.Tag.FONT, characterAction);
            this.tagToAction.put(HTML.Tag.FORM, blockAction);
            this.tagToAction.put(HTML.Tag.FRAME, specialAction);
            this.tagToAction.put(HTML.Tag.FRAMESET, blockAction);
            this.tagToAction.put(HTML.Tag.H1, paragraphAction);
            this.tagToAction.put(HTML.Tag.H2, paragraphAction);
            this.tagToAction.put(HTML.Tag.H3, paragraphAction);
            this.tagToAction.put(HTML.Tag.H4, paragraphAction);
            this.tagToAction.put(HTML.Tag.H5, paragraphAction);
            this.tagToAction.put(HTML.Tag.H6, paragraphAction);
            this.tagToAction.put(HTML.Tag.HEAD, headAction);
            this.tagToAction.put(HTML.Tag.HR, specialAction);
            this.tagToAction.put(HTML.Tag.HTML, blockAction);
            this.tagToAction.put(HTML.Tag.I, characterAction);
            this.tagToAction.put(HTML.Tag.IMG, specialAction);
            this.tagToAction.put(HTML.Tag.INPUT, formAction);
            this.tagToAction.put(HTML.Tag.ISINDEX, isindexAction);
            this.tagToAction.put(HTML.Tag.KBD, characterAction);
            this.tagToAction.put(HTML.Tag.LI, blockAction);
            this.tagToAction.put(HTML.Tag.LINK, linkAction);
            this.tagToAction.put(HTML.Tag.MAP, mapAction);
            this.tagToAction.put(HTML.Tag.MENU, blockAction);
            this.tagToAction.put(HTML.Tag.META, metaAction);
            this.tagToAction.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagToAction.put(HTML.Tag.OBJECT, specialAction);
            this.tagToAction.put(HTML.Tag.OL, blockAction);
            this.tagToAction.put(HTML.Tag.OPTION, formAction);
            this.tagToAction.put(HTML.Tag.P, paragraphAction);
            this.tagToAction.put(HTML.Tag.PARAM, hiddenAction);
            this.tagToAction.put(HTML.Tag.PRE, preAction);
            this.tagToAction.put(HTML.Tag.SAMP, characterAction);
            this.tagToAction.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagToAction.put(HTML.Tag.SELECT, formAction);
            this.tagToAction.put(HTML.Tag.SMALL, characterAction);
            this.tagToAction.put(HTML.Tag.STRIKE, characterAction);
            this.tagToAction.put(HTML.Tag.S, characterAction);
            this.tagToAction.put(HTML.Tag.STRONG, characterAction);
            this.tagToAction.put(HTML.Tag.STYLE, styleAction);
            this.tagToAction.put(HTML.Tag.SUB, characterAction);
            this.tagToAction.put(HTML.Tag.SUP, characterAction);
            this.tagToAction.put(HTML.Tag.TABLE, blockAction);
            this.tagToAction.put(HTML.Tag.TD, blockAction);
            this.tagToAction.put(HTML.Tag.TEXTAREA, formAction);
            this.tagToAction.put(HTML.Tag.TH, blockAction);
            this.tagToAction.put(HTML.Tag.TITLE, titleAction);
            this.tagToAction.put(HTML.Tag.TR, blockAction);
            this.tagToAction.put(HTML.Tag.TT, characterAction);
            this.tagToAction.put(HTML.Tag.U, characterAction);
            this.tagToAction.put(HTML.Tag.UL, blockAction);
            this.tagToAction.put(HTML.Tag.VAR, characterAction);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr);
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.isEmpty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.pop();
            }
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagToAction.put(tag, tagAction);
        }

        public void flush() throws BadLocationException {
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[this.parseBuffer.size()];
            this.parseBuffer.copyInto(objectArray);
            this.parseBuffer.removeAllElements();
            if (this.offset == 0) {
                HTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                HTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.offset += HTMLDocument.this.getLength() - this.offset;
        }

        public void handleText(char[] cArray, int n) {
            if (cArray != null && cArray.length > 0) {
                this.addContent(cArray, 0, cArray.length);
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (this.endHTMLEncountered) {
                return;
            }
            TagAction tagAction = (TagAction)this.tagToAction.get(tag);
            if (tagAction != null) {
                tagAction.start(tag, mutableAttributeSet);
            }
        }

        public void handleComment(char[] cArray, int n) {
            if (this.endHTMLEncountered) {
                return;
            }
            TagAction tagAction = (TagAction)this.tagToAction.get(HTML.Tag.COMMENT);
            if (tagAction != null) {
                tagAction.start(HTML.Tag.COMMENT, new SimpleAttributeSet());
                tagAction.end(HTML.Tag.COMMENT);
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            TagAction tagAction;
            if (this.endHTMLEncountered) {
                return;
            }
            if (tag == HTML.Tag.HTML) {
                this.endHTMLEncountered = true;
            }
            if ((tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                tagAction.end(tag);
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (this.endHTMLEncountered) {
                return;
            }
            TagAction tagAction = (TagAction)this.tagToAction.get(tag);
            if (tagAction != null) {
                tagAction.start(tag, mutableAttributeSet);
                tagAction.end(tag);
            }
        }

        public void handleEndOfLineString(String string) {
            this.print("HTMLReader.handleEndOfLineString not implemented yet");
        }

        protected void textAreaContent(char[] cArray) {
            this.print("HTMLReader.textAreaContent not implemented yet");
        }

        protected void preContent(char[] cArray) {
            this.print("HTMLReader.preContent not implemented yet");
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            DefaultStyledDocument.ElementSpec elementSpec;
            this.printBuffer();
            if (this.parseStack.size() > 0 && this.parseStack.peek() == HTML.Tag.IMPLIED) {
                elementSpec = new DefaultStyledDocument.ElementSpec(null, 2);
                this.parseBuffer.addElement(elementSpec);
                this.parseStack.pop();
            }
            this.parseStack.push(tag);
            AbstractDocument.AttributeContext attributeContext = HTMLDocument.this.getAttributeContext();
            AttributeSet attributeSet = mutableAttributeSet.copyAttributes();
            attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, tag);
            elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 1);
            this.parseBuffer.addElement(elementSpec);
            this.printBuffer();
        }

        protected void blockClose(HTML.Tag tag) {
            DefaultStyledDocument.ElementSpec elementSpec;
            this.printBuffer();
            DefaultStyledDocument.ElementSpec elementSpec2 = (DefaultStyledDocument.ElementSpec)this.parseBuffer.get(this.parseBuffer.size() - 1);
            if (elementSpec2.getType() == 1) {
                AbstractDocument.AttributeContext attributeContext = HTMLDocument.this.getAttributeContext();
                AttributeSet attributeSet = attributeContext.getEmptySet();
                attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, new char[0], 0, 0);
                this.parseBuffer.add(elementSpec);
            } else if (this.parseStack.peek() == HTML.Tag.IMPLIED) {
                elementSpec = new DefaultStyledDocument.ElementSpec(null, 2);
                this.parseBuffer.addElement(elementSpec);
                if (this.parseStack.size() > 0) {
                    this.parseStack.pop();
                }
            }
            elementSpec = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(elementSpec);
            this.printBuffer();
            if (this.parseStack.size() > 0) {
                this.parseStack.pop();
            }
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            DefaultStyledDocument.ElementSpec elementSpec;
            AbstractDocument.AttributeContext attributeContext = HTMLDocument.this.getAttributeContext();
            AttributeSet attributeSet = null;
            boolean bl2 = false;
            HTML.Tag tag = (HTML.Tag)this.parseStack.peek();
            if (tag != HTML.Tag.P && tag != HTML.Tag.H1 && tag != HTML.Tag.H2 && tag != HTML.Tag.H3 && tag != HTML.Tag.H4 && tag != HTML.Tag.H5 && tag != HTML.Tag.H6 && tag != HTML.Tag.TD) {
                attributeSet = attributeContext.getEmptySet();
                attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.IMPLIED);
                elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 1);
                this.parseBuffer.add(elementSpec);
                this.parseStack.push(HTML.Tag.IMPLIED);
            }
            attributeSet = this.charAttr != null ? this.charAttr.copyAttributes() : attributeContext.getEmptySet();
            attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n, n2);
            this.printBuffer();
            this.parseBuffer.addElement(elementSpec);
            this.printBuffer();
            if (this.parseBuffer.size() > HTMLDocument.this.getTokenThreshold()) {
                try {
                    this.flush();
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            this.print("HTMLReader.addSpecialElement not implemented yet");
        }

        void printBuffer() {
            this.print("\n*********BUFFER**********");
            int n = 0;
            while (n < this.parseBuffer.size()) {
                this.print("  " + this.parseBuffer.get(n));
                ++n;
            }
            this.print("***************************");
        }

        private final /* synthetic */ void this() {
            this.charAttr = new SimpleAttributeSet();
            this.parseBuffer = new Vector();
            this.charAttrStack = new Stack();
            this.parseStack = new Stack();
            this.endHTMLEncountered = false;
            this.insertTagEncountered = false;
            this.debug = false;
        }

        public HTMLReader(int n) {
            this(n, 0, 0, null);
        }

        public HTMLReader(int n, int n2, int n3, HTML.Tag tag) {
            this.this();
            this.print("HTMLReader created with pop: " + n2 + " push: " + n3 + " offset: " + n + " tag: " + tag);
            this.insertTag = tag;
            this.offset = n;
            this.popDepth = n2;
            this.pushDepth = n3;
            this.initTags();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class CharacterAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                if (mutableAttributeSet != null) {
                    HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class HiddenAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("HiddenAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("HiddenAction.end not implemented");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class AreaAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("AreaAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("AreaAction.end not implemented");
            }

            AreaAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class BaseAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("BaseAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("BaseAction.end not implemented");
            }

            BaseAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class BlockAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("SpecialAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("SpecialAction.end not implemented");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class ParagraphAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class HeadAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("HeadAction.start not implemented: " + tag);
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("HeadAction.end not implemented: " + tag);
                super.end(tag);
            }

            HeadAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class FormAction
        extends SpecialAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("FormAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("FormAction.end not implemented");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("IsindexAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("IsindexAction.end not implemented");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class LinkAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("LinkAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("LinkAction.end not implemented");
            }

            LinkAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class MapAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("MapAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("MapAction.end not implemented");
            }

            MapAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class PreAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("PreAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("PreAction.end not implemented");
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class MetaAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("MetaAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("MetaAction.end not implemented");
            }

            MetaAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class StyleAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("StyleAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("StyleAction.end not implemented");
            }

            StyleAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class TitleAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.print("TitleAction.start not implemented");
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.print("TitleAction.end not implemented");
            }

            TitleAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getEndOffset();

        public abstract int getStartOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }
}

