/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;

public class MethodCallHandler
extends ExpressionHandler {
    public MethodCallHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, aAst.getType() == 43 ? "ctor call" : "method call", aAst, aParent);
    }

    private void checkLParen() {
        DetailAST lparen = this.getMainAst();
        int columnNo = this.expandedTabsColumnNo(lparen);
        if (columnNo == this.getLevel()) {
            return;
        }
        if (!this.startsLine(lparen)) {
            return;
        }
        this.logError(lparen, "lparen", columnNo);
    }

    private void checkRParen() {
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        int columnNo = this.expandedTabsColumnNo(rparen);
        if (columnNo == this.getLevel()) {
            return;
        }
        if (!this.startsLine(rparen)) {
            return;
        }
        this.logError(rparen, "rparen", columnNo);
    }

    public int getLevelImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = ((MethodCallHandler)this.getParent()).findContainingMethodCall(this);
            if (container != null) {
                if (ExpressionHandler.areOnSameLine(container.getMainAst(), this.getMainAst())) {
                    return container.getLevel();
                }
                return container.getLevel() + this.getIndentCheck().getBasicOffset();
            }
            ExpressionHandler p = this.getParent();
            while (p instanceof MethodCallHandler) {
                p = p.getParent();
            }
            return p.suggestedChildLevel(this);
        }
        LineSet lines = new LineSet();
        this.findSubtreeLines(lines, (DetailAST)this.getMainAst().getFirstChild(), true);
        int firstCol = lines.firstLineCol();
        int lineStart = this.getLineStart(this.getFirstAst(this.getMainAst()));
        if (lineStart != firstCol) {
            return lineStart;
        }
        return super.getLevelImpl();
    }

    private DetailAST getFirstAst(DetailAST aAst) {
        DetailAST ast = (DetailAST)aAst.getFirstChild();
        while (ast != null && ast.getType() == 59) {
            ast = (DetailAST)ast.getFirstChild();
        }
        if (ast == null) {
            ast = aAst;
        }
        return ast;
    }

    public int suggestedChildLevel(ExpressionHandler aChild) {
        DetailAST first = (DetailAST)this.getMainAst().getFirstChild();
        int indentLevel = this.getLineStart(first);
        if (aChild instanceof MethodCallHandler && !ExpressionHandler.areOnSameLine((DetailAST)aChild.getMainAst().getFirstChild(), (DetailAST)this.getMainAst().getFirstChild())) {
            indentLevel += this.getIndentCheck().getBasicOffset();
        }
        return indentLevel;
    }

    private MethodCallHandler findContainingMethodCall(ExpressionHandler aChild) {
        DetailAST firstChild = (DetailAST)this.getMainAst().getFirstChild();
        DetailAST secondChild = (DetailAST)firstChild.getNextSibling();
        DetailAST climber = aChild.getMainAst().getParent();
        while (climber != null) {
            if (climber == firstChild) {
                if (this.getParent() instanceof MethodCallHandler) {
                    return ((MethodCallHandler)this.getParent()).findContainingMethodCall(this);
                }
                return null;
            }
            if (climber == secondChild) {
                return this;
            }
            climber = climber.getParent();
        }
        return null;
    }

    public void checkIndentation() {
        DetailAST methodName = (DetailAST)this.getMainAst().getFirstChild();
        this.checkExpressionSubtree(methodName, this.getLevel(), false, false);
        this.checkLParen();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        DetailAST lparen = this.getMainAst();
        if (rparen.getLineNo() != lparen.getLineNo()) {
            this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), this.getLevel() + this.getIndentCheck().getBasicOffset(), false, true);
            this.checkRParen();
        }
    }

    protected boolean shouldIncraeseIndent() {
        return false;
    }
}

