package Foomatic::Defaults;

use vars qw(@EXPORT @EXPORT_OK $libdir $bindir $sysdeps $DEBUG);

require Exporter;
@ISA = qw/Exporter/;
@EXPORT = qw($libdir $bindir $sysdeps);
@EXPORT_OK = qw($DEBUG);

# Debug flag; set this to enable debugging messages from Perl modules.
$DEBUG = '';

# Library directory; typically /usr/share/foomatic or somesuch.
$libdir = '/usr/local/share/foomatic';
$libdir = $ENV{FOOMATICDB} if $ENV{FOOMATICDB};

# Binary directory; typically /usr/bin or somesuch.
$bindir = '/usr/local/bin';

# System configuration list
$sysdeps = {
    'foo-etc'    => '/etc/foomatic',
    'foomatic-rip'=> '/usr/local/bin/foomatic-rip',
    'lpd-dir'    => '/var/spool/output',
    'lpd-log'    => '/var/log/lpd-errs',
    'lpd-bin'    => '/usr/sbin/lpd',
    'lpd-pcap'   => '/etc/printcap',
    'lprng-conf' => '/etc/lpd.conf',
    'lpd-lpr'    => '/usr/bin/lpr',
    'lpd-lpq'    => '/usr/bin/lpq',
    'lpd-lprm'   => '/usr/bin/lprm',
    'lpd-lpc'    => '/usr/sbin/lpc',
    'lprng-checkpc' => '/usr/local/sbin/checkpc',
    'cups-etc'   => '/etc/cups',
    'cups-admin' => '/usr/local/sbin/lpadmin',
    'cups-lpstat' => '/usr/local/bin/lpstat',
    'cups-ppds'  => '/usr/local/share/cups/model',
    'cups-filters' => '/usr/local/libexec/cups/filter',
    'cups-backends' => '/usr/local/libexec/cups/backend',
    'cups-driver' => '/usr/lib/cups/driver',
    'cups-pconf' => '/etc/cups/printers.conf',
    'cups-lpr'   => '/usr/local/bin/lpr',
    'cups-lpq'   => '/usr/local/bin/lpq',
    'cups-lprm'  => '/usr/local/bin/lprm',
    'cups-lpc'   => '/usr/local/sbin/lpc',
    'cups-lp'    => '/usr/local/bin/lp',
    'cups-cancel' => '/usr/local/bin/cancel',
    'cups-enable' => '/usr/local/bin/enable',
    'cups-disable' => '/usr/local/bin/disable',
    'cups-accept' => '/usr/local/sbin/accept',
    'cups-reject' => '/usr/local/sbin/reject',
    'cups-lpmove' => '/usr/local/sbin/lpmove',
    'cups-lpoptions' => '/usr/local/bin/lpoptions',
    'cups-lpinfo' => '/usr/local/sbin/lpinfo',
    'pdq-conf'   => '',
    'pdq-printrc' => '',
    'pdq-foomatic' => '/drivers/foomatic',
    'pdq-print'  => '',
    'pdq-jobdir' => '~/.printjobs',
    'ppr-pprd' => '',
    'ppr-interfaces' => '',
    'ppr-ppdfiles' => '',
    'ppr-etc' => '',
    'ppr-ppr' => '',
    'ppr-ppad' => '',
    'ppr-ppop' => '',
    'direct-etc' => '/etc/foomatic/direct',
    'direct-config' => '/etc/foomatic/direct/.config',
    'nc' => '/usr/bin/nc',
    'rlpr' => '/usr/bin/rlpr',
    'smbclient' => '/usr/local/bin/smbclient',
    'nprint' => '/usr/bin/nprint',
    'ptal-connect' => '/usr/bin/ptal-connect',
    'ptal-pipes' => '/var/run/ptal-printd',
    'mtink-pipes' => '/var/mtink',
    'cat' => '/bin/cat',
    'gzip' => '/usr/bin/gzip',
    'wget' => '/usr/local/bin/wget',
    'curl' => '/usr/local/bin/curl'
};

