;;; latin-euro-standards.el -*- coding: iso-2022-7 -*-

;; Copyright (C) 2002 Free Software Foundation, Inc

;; Author: Aidan Kehoe
;; Keywords: mule, charsets
;; Created: 2005 February 7
;; Last-modified: 2005 February 7

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; The latin-euro-standards package provides coding systems, Mule character
;; sets, and language environments for the ISO-8859-13, -14, -15 and -16
;; standard character encodings. Besides the Euro sign--whence the name of
;; this package--among these encodings we have single-width directed
;; quotation marks, handy if you're if you're in an environment where your
;; TTY has a UTF-8 coding system which interprets these characters as
;; single-width.

;; These have been refactored out from the latin-unity package because it
;; turns out that, to have Mule-UCS support the Euro sign, the simplest
;; approach is to have these character sets available to it when
;; byte-compiling. Since latin-unity already depends on mule-ucs, and since
;; moving these character sets out from latin-unity and making it depend on
;; them is pretty practical, we've moved them here, to avoid a nasty
;; circular dependency.

;;; Code:

(require 'latin-euro-latin7)
(require 'latin-euro-latin8)
(require 'latin-euro-latin9)
(require 'latin-euro-latin10)

(provide 'latin-euro-standards)
;; end of latin-euro-standards.el