/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;

public class EncodingHelper {
    private static HashMap canonicalNames = new HashMap();

    public static String getDefaultEncoding() {
        try {
            return System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "8859_1";
    }

    public static String getOldCanonical(String string) {
        String string2 = (String)canonicalNames.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static boolean isISOLatin1(String string) {
        return string.equals("ISO-8859-1") || string.equals("8859_1") || string.equals("ISO_8859-1") || string.equals("latin1") || string.equals("ISO8859_1") || string.equals("ISO_8859_1");
    }

    public static Charset getCharset(String string) throws UnsupportedEncodingException {
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException("Charset " + string + " not found.");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException("Charset " + string + " not found.");
        }
    }

    static {
        canonicalNames.put("US-ASCII", "ASCII");
        canonicalNames.put("windows-1250", "Cp1250");
        canonicalNames.put("windows-1251", "Cp1251");
        canonicalNames.put("windows-1252", "Cp1252");
        canonicalNames.put("windows-1253", "Cp1253");
        canonicalNames.put("windows-1254", "Cp1254");
        canonicalNames.put("windows-1257", "Cp1257");
        canonicalNames.put("ISO-8859-1", "ISO8859_1");
        canonicalNames.put("ISO-8859-2", "ISO8859_2");
        canonicalNames.put("ISO-8859-4", "ISO8859_4");
        canonicalNames.put("ISO-8859-5", "ISO8859_5");
        canonicalNames.put("ISO-8859-7", "ISO8859_7");
        canonicalNames.put("ISO-8859-9", "ISO8859_9");
        canonicalNames.put("ISO-8859-13", "ISO8859_13");
        canonicalNames.put("ISO-8859-15", "ISO8859_15");
        canonicalNames.put("KOI8-R", "KOI8_R");
        canonicalNames.put("UTF-8", "UTF8");
        canonicalNames.put("UTF-16BE", "UnicodeBigUnmarked");
        canonicalNames.put("UTF-16LE", "UnicodeLittleUnmarked");
        canonicalNames.put("windows-1255", "Cp1255");
        canonicalNames.put("windows-1256", "Cp1256");
        canonicalNames.put("windows-1258", "Cp1258");
        canonicalNames.put("ISO-8859-3", "ISO8859_3");
        canonicalNames.put("ISO-8859-6", "ISO8859_6");
        canonicalNames.put("ISO-8859-8", "ISO8859_8");
    }
}

