/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.classpath.NotImplementedException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);
    private JTextComponent textComponent;
    private ArrayList highlights;
    private boolean drawsLayeredHighlights;

    private /* synthetic */ void finit$() {
        this.highlights = new ArrayList();
        this.drawsLayeredHighlights = true;
    }

    public DefaultHighlighter() {
        this.finit$();
    }

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.drawsLayeredHighlights = bl;
    }

    private void checkPositions(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("DefaultHighlighter", n);
        }
        if (n2 < n) {
            throw new BadLocationException("DefaultHighlighter", n2);
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textComponent = null;
    }

    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        this.checkPositions(n, n2);
        HighlightEntry highlightEntry = new HighlightEntry(this, n, n2, highlightPainter);
        this.highlights.add(highlightEntry);
        this.textComponent.getUI().damageRange(this.textComponent, n, n2);
        return highlightEntry;
    }

    public void removeHighlight(Object object) {
        this.highlights.remove(object);
        HighlightEntry highlightEntry = (HighlightEntry)object;
        this.textComponent.getUI().damageRange(this.textComponent, highlightEntry.p0, highlightEntry.p1);
    }

    public void removeAllHighlights() {
        this.highlights.clear();
    }

    public Highlighter.Highlight[] getHighlights() {
        return (Highlighter.Highlight[])this.highlights.toArray(new Highlighter.Highlight[this.highlights.size()]);
    }

    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        this.checkPositions(n, n2);
        HighlightEntry highlightEntry = (HighlightEntry)object;
        int n3 = highlightEntry.p0;
        int n4 = highlightEntry.p1;
        if (n3 == n && n4 == n2) {
            return;
        }
        highlightEntry.p0 = n;
        highlightEntry.p1 = n2;
        TextUI textUI = this.textComponent.getUI();
        if (n == n2) {
            textUI.damageRange(this.textComponent, n3, n4);
        } else if (n4 > n && n4 <= n2 || n2 > n3 && n2 <= n4) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (n3 < n) {
                n8 = n3;
                n7 = n;
            } else {
                n8 = n;
                n7 = n3;
            }
            if (n4 < n2) {
                n6 = n4;
                n5 = n2;
            } else {
                n6 = n2;
                n5 = n4;
            }
            if (n7 == n6) {
                textUI.damageRange(this.textComponent, n8, n5);
            } else {
                if (n8 != n7) {
                    textUI.damageRange(this.textComponent, n8, n7);
                }
                if (n6 != n5) {
                    textUI.damageRange(this.textComponent, n6, n5);
                }
            }
        } else {
            textUI.damageRange(this.textComponent, n3, n4);
            textUI.damageRange(this.textComponent, n, n2);
        }
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) throws NotImplementedException {
    }

    public void paint(Graphics graphics) {
        int n = this.highlights.size();
        if (n == 0) {
            return;
        }
        Insets insets = this.textComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, this.textComponent.getWidth() - insets.left - insets.right, this.textComponent.getHeight() - insets.top - insets.bottom);
        for (int i = 0; i < n; ++i) {
            HighlightEntry highlightEntry = (HighlightEntry)this.highlights.get(i);
            highlightEntry.painter.paint(graphics, highlightEntry.p0, highlightEntry.p1, rectangle, this.textComponent);
        }
    }

    private class HighlightEntry
    implements Highlighter.Highlight {
        private /* synthetic */ DefaultHighlighter this$0;
        int p0;
        int p1;
        Highlighter.HighlightPainter painter;

        public HighlightEntry(DefaultHighlighter defaultHighlighter, int n, int n2, Highlighter.HighlightPainter highlightPainter) {
            this.this$0 = defaultHighlighter;
            this.p0 = n;
            this.p1 = n2;
            this.painter = highlightPainter;
        }

        public int getStartOffset() {
            return this.p0;
        }

        public int getEndOffset() {
            return this.p1;
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        private void paintHighlight(Graphics graphics, Rectangle rectangle) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            if (n == n2) {
                return;
            }
            Rectangle rectangle = shape.getBounds();
            if (this.color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(this.color);
            }
            TextUI textUI = jTextComponent.getUI();
            try {
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n, null);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2, null);
                if (rectangle2.y == rectangle3.y) {
                    SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle3);
                    SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle3);
                    this.paintHighlight(graphics, rectangle3);
                } else {
                    rectangle2.x -= rectangle.x;
                    rectangle2.width = rectangle.width - rectangle2.x - rectangle.x;
                    this.paintHighlight(graphics, rectangle2);
                    int n3 = Utilities.getPositionBelow(jTextComponent, n, rectangle2.x);
                    int n4 = Utilities.getRowStart(jTextComponent, n2);
                    if (n3 != -1 && n3 != n && Utilities.getRowStart(jTextComponent, n3) != n4) {
                        Rectangle rectangle4 = textUI.modelToView(jTextComponent, n3);
                        rectangle4.x = rectangle.x;
                        rectangle4.width = rectangle.width;
                        int n5 = n3;
                        while (n5 != -1 && Utilities.getRowStart(jTextComponent, n5) != n4 && (n5 = Utilities.getPositionBelow(jTextComponent, n3 = n5, rectangle2.x)) != n3) {
                        }
                        Rectangle rectangle5 = textUI.modelToView(jTextComponent, n3);
                        rectangle4.height = rectangle5.y + rectangle5.height - rectangle4.y;
                        this.paintHighlight(graphics, rectangle4);
                    }
                    rectangle3.width = rectangle3.x + rectangle3.width - rectangle.x;
                    rectangle3.x = rectangle.x;
                    this.paintHighlight(graphics, rectangle3);
                }
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)"Unexpected bad location exception");
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            throw new InternalError();
        }
    }
}

