require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &alpha;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"alpha";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &alpha;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"alpha";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_ALPHA;}
}
if(defined(&_KERNEL)) {
    require 'machine/cpu.ph';
}
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	 &_ALIGNBYTES;}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	my($p) = @_;
	eval q( &_ALIGN($p));
    }
}
unless(defined(&ALIGNED_POINTER)) {
    sub ALIGNED_POINTER {
	my($p,$t) = @_;
	eval q( &_ALIGNED_POINTER($p,$t));
    }
}
unless(defined(&NBPG)) {
    sub NBPG () {	(1<< 13);}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	13;}
}
unless(defined(&PAGE_SHIFT)) {
    sub PAGE_SHIFT () {	13;}
}
unless(defined(&PAGE_SIZE)) {
    sub PAGE_SIZE () {	(1<<  &PAGE_SHIFT);}
}
unless(defined(&PAGE_MASK)) {
    sub PAGE_MASK () {	( &PAGE_SIZE - 1);}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0xfffffc0000580000;}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	(1<<  &DEV_BSHIFT);}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES *  &NBPG);}
}
unless(defined(&USPACE_ALIGN)) {
    sub USPACE_ALIGN () {	(0);}
}
unless(defined(&MSGBUFSIZE)) {
    eval 'sub MSGBUFSIZE () { &NBPG;}' unless defined(&MSGBUFSIZE);
}
unless(defined(&NMBCLUSTERS)) {
    sub NMBCLUSTERS () {	4096;}
}
unless(defined(&NKMEMPAGES_MIN_DEFAULT)) {
    sub NKMEMPAGES_MIN_DEFAULT () {	((8* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&NKMEMPAGES_MAX_DEFAULT)) {
    sub NKMEMPAGES_MAX_DEFAULT () {	((128* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&ctod)) {
    sub ctod {
	my($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	my($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	my($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	my($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	require 'machine/intr.ph';
	eval 'sub DELAY {
	    my($n) = @_;
    	    eval q( &delay($n));
	}' unless defined(&DELAY);
    }
}
1;
