require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ARMREG_H)) {
    eval 'sub _ARM_ARMREG_H () {1;}' unless defined(&_ARM_ARMREG_H);
    eval 'sub PSR_FLAGS () {0xf0000000;}' unless defined(&PSR_FLAGS);
    eval 'sub PSR_N_bit () {(1<< 31);}' unless defined(&PSR_N_bit);
    eval 'sub PSR_Z_bit () {(1<< 30);}' unless defined(&PSR_Z_bit);
    eval 'sub PSR_C_bit () {(1<< 29);}' unless defined(&PSR_C_bit);
    eval 'sub PSR_V_bit () {(1<< 28);}' unless defined(&PSR_V_bit);
    eval 'sub PSR_Q_bit () {(1<< 27);}' unless defined(&PSR_Q_bit);
    eval 'sub I32_bit () {(1<< 7);}' unless defined(&I32_bit);
    eval 'sub F32_bit () {(1<< 6);}' unless defined(&F32_bit);
    eval 'sub PSR_T_bit () {(1<< 5);}' unless defined(&PSR_T_bit);
    eval 'sub PSR_J_bit () {(1<< 24);}' unless defined(&PSR_J_bit);
    eval 'sub PSR_MODE () {0x1f;}' unless defined(&PSR_MODE);
    eval 'sub PSR_USR26_MODE () {0x;}' unless defined(&PSR_USR26_MODE);
    eval 'sub PSR_FIQ26_MODE () {0x1;}' unless defined(&PSR_FIQ26_MODE);
    eval 'sub PSR_IRQ26_MODE () {0x2;}' unless defined(&PSR_IRQ26_MODE);
    eval 'sub PSR_SVC26_MODE () {0x3;}' unless defined(&PSR_SVC26_MODE);
    eval 'sub PSR_USR32_MODE () {0x10;}' unless defined(&PSR_USR32_MODE);
    eval 'sub PSR_FIQ32_MODE () {0x11;}' unless defined(&PSR_FIQ32_MODE);
    eval 'sub PSR_IRQ32_MODE () {0x12;}' unless defined(&PSR_IRQ32_MODE);
    eval 'sub PSR_SVC32_MODE () {0x13;}' unless defined(&PSR_SVC32_MODE);
    eval 'sub PSR_ABT32_MODE () {0x17;}' unless defined(&PSR_ABT32_MODE);
    eval 'sub PSR_UND32_MODE () {0x1b;}' unless defined(&PSR_UND32_MODE);
    eval 'sub PSR_SYS32_MODE () {0x1f;}' unless defined(&PSR_SYS32_MODE);
    eval 'sub PSR_32_MODE () {0x10;}' unless defined(&PSR_32_MODE);
    eval 'sub PSR_IN_USR_MODE {
        my($psr) = @_;
	    eval q((!(($psr) & 3)));
    }' unless defined(&PSR_IN_USR_MODE);
    eval 'sub ARM_CP15_CPU_ID () {0;}' unless defined(&ARM_CP15_CPU_ID);
    eval 'sub CPU_ID_IMPLEMENTOR_MASK () {0xff000000;}' unless defined(&CPU_ID_IMPLEMENTOR_MASK);
    eval 'sub CPU_ID_ARM_LTD () {0x41000000;}' unless defined(&CPU_ID_ARM_LTD);
    eval 'sub CPU_ID_DEC () {0x44000000;}' unless defined(&CPU_ID_DEC);
    eval 'sub CPU_ID_INTEL () {0x69000000;}' unless defined(&CPU_ID_INTEL);
    eval 'sub CPU_ID_TI () {0x54000000;}' unless defined(&CPU_ID_TI);
    eval 'sub CPU_ID_ISOLD {
        my($x) = @_;
	    eval q(((($x) & 0xf000) == 0x));
    }' unless defined(&CPU_ID_ISOLD);
    eval 'sub CPU_ID_IS7 {
        my($x) = @_;
	    eval q(((($x) & 0xf000) == 0x7000));
    }' unless defined(&CPU_ID_IS7);
    eval 'sub CPU_ID_ISNEW {
        my($x) = @_;
	    eval q((! &CPU_ID_ISOLD($x)  && ! &CPU_ID_IS7($x)));
    }' unless defined(&CPU_ID_ISNEW);
    eval 'sub CPU_ID_FOUNDRY_MASK () {0xff0000;}' unless defined(&CPU_ID_FOUNDRY_MASK);
    eval 'sub CPU_ID_FOUNDRY_VLSI () {0x560000;}' unless defined(&CPU_ID_FOUNDRY_VLSI);
    eval 'sub CPU_ID_7ARCH_MASK () {0x800000;}' unless defined(&CPU_ID_7ARCH_MASK);
    eval 'sub CPU_ID_7ARCH_V3 () {0x;}' unless defined(&CPU_ID_7ARCH_V3);
    eval 'sub CPU_ID_7ARCH_V4T () {0x800000;}' unless defined(&CPU_ID_7ARCH_V4T);
    eval 'sub CPU_ID_7VARIANT_MASK () {0x7f0000;}' unless defined(&CPU_ID_7VARIANT_MASK);
    eval 'sub CPU_ID_ARCH_MASK () {0xf0000;}' unless defined(&CPU_ID_ARCH_MASK);
    eval 'sub CPU_ID_ARCH_V3 () {0x;}' unless defined(&CPU_ID_ARCH_V3);
    eval 'sub CPU_ID_ARCH_V4 () {0x10000;}' unless defined(&CPU_ID_ARCH_V4);
    eval 'sub CPU_ID_ARCH_V4T () {0x20000;}' unless defined(&CPU_ID_ARCH_V4T);
    eval 'sub CPU_ID_ARCH_V5 () {0x30000;}' unless defined(&CPU_ID_ARCH_V5);
    eval 'sub CPU_ID_ARCH_V5T () {0x40000;}' unless defined(&CPU_ID_ARCH_V5T);
    eval 'sub CPU_ID_ARCH_V5TE () {0x50000;}' unless defined(&CPU_ID_ARCH_V5TE);
    eval 'sub CPU_ID_ARCH_V6 () {0x70000;}' unless defined(&CPU_ID_ARCH_V6);
    eval 'sub CPU_ID_ARCH_V7 () {0x80000;}' unless defined(&CPU_ID_ARCH_V7);
    eval 'sub CPU_ID_VARIANT_MASK () {0xf00000;}' unless defined(&CPU_ID_VARIANT_MASK);
    eval 'sub CPU_ID_PARTNO_MASK () {0xfff0;}' unless defined(&CPU_ID_PARTNO_MASK);
    eval 'sub CPU_ID_XSCALE_COREGEN_MASK () {0xe000;}' unless defined(&CPU_ID_XSCALE_COREGEN_MASK);
    eval 'sub CPU_ID_XSCALE_COREREV_MASK () {0x1c00;}' unless defined(&CPU_ID_XSCALE_COREREV_MASK);
    eval 'sub CPU_ID_XSCALE_PRODUCT_MASK () {0x3f0;}' unless defined(&CPU_ID_XSCALE_PRODUCT_MASK);
    eval 'sub CPU_ID_REVISION_MASK () {0xf;}' unless defined(&CPU_ID_REVISION_MASK);
    eval 'sub CPU_ID_CPU_MASK () {0xfffffff0;}' unless defined(&CPU_ID_CPU_MASK);
    eval 'sub CPU_ID_ARM2 () {0x41560200;}' unless defined(&CPU_ID_ARM2);
    eval 'sub CPU_ID_ARM250 () {0x41560250;}' unless defined(&CPU_ID_ARM250);
    eval 'sub CPU_ID_ARM3 () {0x41560300;}' unless defined(&CPU_ID_ARM3);
    eval 'sub CPU_ID_ARM600 () {0x41560600;}' unless defined(&CPU_ID_ARM600);
    eval 'sub CPU_ID_ARM610 () {0x41560610;}' unless defined(&CPU_ID_ARM610);
    eval 'sub CPU_ID_ARM620 () {0x41560620;}' unless defined(&CPU_ID_ARM620);
    eval 'sub CPU_ID_ARM700 () {0x41007000;}' unless defined(&CPU_ID_ARM700);
    eval 'sub CPU_ID_ARM710 () {0x41007100;}' unless defined(&CPU_ID_ARM710);
    eval 'sub CPU_ID_ARM7500 () {0x41027100;}' unless defined(&CPU_ID_ARM7500);
    eval 'sub CPU_ID_ARM710A () {0x41047100;}' unless defined(&CPU_ID_ARM710A);
    eval 'sub CPU_ID_ARM7500FE () {0x41077100;}' unless defined(&CPU_ID_ARM7500FE);
    eval 'sub CPU_ID_ARM710T () {0x41807100;}' unless defined(&CPU_ID_ARM710T);
    eval 'sub CPU_ID_ARM720T () {0x41807200;}' unless defined(&CPU_ID_ARM720T);
    eval 'sub CPU_ID_ARM740T8K () {0x41807400;}' unless defined(&CPU_ID_ARM740T8K);
    eval 'sub CPU_ID_ARM740T4K () {0x41817400;}' unless defined(&CPU_ID_ARM740T4K);
    eval 'sub CPU_ID_ARM810 () {0x41018100;}' unless defined(&CPU_ID_ARM810);
    eval 'sub CPU_ID_ARM920T () {0x41129200;}' unless defined(&CPU_ID_ARM920T);
    eval 'sub CPU_ID_ARM922T () {0x41029220;}' unless defined(&CPU_ID_ARM922T);
    eval 'sub CPU_ID_ARM926EJS () {0x41069260;}' unless defined(&CPU_ID_ARM926EJS);
    eval 'sub CPU_ID_ARM940T () {0x41029400;}' unless defined(&CPU_ID_ARM940T);
    eval 'sub CPU_ID_ARM946ES () {0x41049460;}' unless defined(&CPU_ID_ARM946ES);
    eval 'sub CPU_ID_ARM966ES () {0x41049660;}' unless defined(&CPU_ID_ARM966ES);
    eval 'sub CPU_ID_ARM966ESR1 () {0x41059660;}' unless defined(&CPU_ID_ARM966ESR1);
    eval 'sub CPU_ID_ARM1020E () {0x4115a200;}' unless defined(&CPU_ID_ARM1020E);
    eval 'sub CPU_ID_ARM1022ES () {0x4105a220;}' unless defined(&CPU_ID_ARM1022ES);
    eval 'sub CPU_ID_ARM1026EJS () {0x4106a260;}' unless defined(&CPU_ID_ARM1026EJS);
    eval 'sub CPU_ID_ARM1136JS () {0x4107b360;}' unless defined(&CPU_ID_ARM1136JS);
    eval 'sub CPU_ID_ARM1136JSR1 () {0x4117b360;}' unless defined(&CPU_ID_ARM1136JSR1);
    eval 'sub CPU_ID_SA110 () {0x4401a100;}' unless defined(&CPU_ID_SA110);
    eval 'sub CPU_ID_SA1100 () {0x4401a110;}' unless defined(&CPU_ID_SA1100);
    eval 'sub CPU_ID_TI925T () {0x54029250;}' unless defined(&CPU_ID_TI925T);
    eval 'sub CPU_ID_SA1110 () {0x6901b110;}' unless defined(&CPU_ID_SA1110);
    eval 'sub CPU_ID_IXP1200 () {0x6901c120;}' unless defined(&CPU_ID_IXP1200);
    eval 'sub CPU_ID_80200 () {0x69052000;}' unless defined(&CPU_ID_80200);
    eval 'sub CPU_ID_PXA250 () {0x69052100;}' unless defined(&CPU_ID_PXA250);
    eval 'sub CPU_ID_PXA210 () {0x69052120;}' unless defined(&CPU_ID_PXA210);
    eval 'sub CPU_ID_PXA250A () {0x69052100;}' unless defined(&CPU_ID_PXA250A);
    eval 'sub CPU_ID_PXA210A () {0x69052120;}' unless defined(&CPU_ID_PXA210A);
    eval 'sub CPU_ID_PXA250B () {0x69052900;}' unless defined(&CPU_ID_PXA250B);
    eval 'sub CPU_ID_PXA210B () {0x69052920;}' unless defined(&CPU_ID_PXA210B);
    eval 'sub CPU_ID_PXA250C () {0x69052d00;}' unless defined(&CPU_ID_PXA250C);
    eval 'sub CPU_ID_PXA210C () {0x69052d20;}' unless defined(&CPU_ID_PXA210C);
    eval 'sub CPU_ID_80219_400 () {0x69052e20;}' unless defined(&CPU_ID_80219_400);
    eval 'sub CPU_ID_80219_600 () {0x69052e30;}' unless defined(&CPU_ID_80219_600);
    eval 'sub CPU_ID_PXA27X () {0x69054110;}' unless defined(&CPU_ID_PXA27X);
    eval 'sub CPU_ID_80321_400 () {0x69052420;}' unless defined(&CPU_ID_80321_400);
    eval 'sub CPU_ID_80321_600 () {0x69052430;}' unless defined(&CPU_ID_80321_600);
    eval 'sub CPU_ID_80321_400_B0 () {0x69052c20;}' unless defined(&CPU_ID_80321_400_B0);
    eval 'sub CPU_ID_80321_600_B0 () {0x69052c30;}' unless defined(&CPU_ID_80321_600_B0);
    eval 'sub CPU_ID_IXP425_533 () {0x690541c0;}' unless defined(&CPU_ID_IXP425_533);
    eval 'sub CPU_ID_IXP425_400 () {0x690541d0;}' unless defined(&CPU_ID_IXP425_400);
    eval 'sub CPU_ID_IXP425_266 () {0x690541f0;}' unless defined(&CPU_ID_IXP425_266);
    eval 'sub CPU_ID_CORTEX_A8 () {0x410fc080;}' unless defined(&CPU_ID_CORTEX_A8);
    eval 'sub CPU_ID_CORTEX_A8_MASK () {0xff0fffe0;}' unless defined(&CPU_ID_CORTEX_A8_MASK);
    eval 'sub CPU_ID_OMAP3430 () {0x411fc080;}' unless defined(&CPU_ID_OMAP3430);
    eval 'sub CPU_ID_OMAP3530 () {0x411fc090;}' unless defined(&CPU_ID_OMAP3530);
    eval 'sub CPU_ID_OMAP3630 () {0x413fc080;}' unless defined(&CPU_ID_OMAP3630);
    eval 'sub ARM3_CP15_FLUSH () {1;}' unless defined(&ARM3_CP15_FLUSH);
    eval 'sub ARM3_CP15_CONTROL () {2;}' unless defined(&ARM3_CP15_CONTROL);
    eval 'sub ARM3_CP15_CACHEABLE () {3;}' unless defined(&ARM3_CP15_CACHEABLE);
    eval 'sub ARM3_CP15_UPDATEABLE () {4;}' unless defined(&ARM3_CP15_UPDATEABLE);
    eval 'sub ARM3_CP15_DISRUPTIVE () {5;}' unless defined(&ARM3_CP15_DISRUPTIVE);
    eval 'sub ARM3_CTL_CACHE_ON () {0x1;}' unless defined(&ARM3_CTL_CACHE_ON);
    eval 'sub ARM3_CTL_SHARED () {0x2;}' unless defined(&ARM3_CTL_SHARED);
    eval 'sub ARM3_CTL_MONITOR () {0x4;}' unless defined(&ARM3_CTL_MONITOR);
    eval 'sub CPU_CONTROL_MMU_ENABLE () {0x1;}' unless defined(&CPU_CONTROL_MMU_ENABLE);
    eval 'sub CPU_CONTROL_AFLT_ENABLE () {0x2;}' unless defined(&CPU_CONTROL_AFLT_ENABLE);
    eval 'sub CPU_CONTROL_DC_ENABLE () {0x4;}' unless defined(&CPU_CONTROL_DC_ENABLE);
    eval 'sub CPU_CONTROL_WBUF_ENABLE () {0x8;}' unless defined(&CPU_CONTROL_WBUF_ENABLE);
    eval 'sub CPU_CONTROL_32BP_ENABLE () {0x10;}' unless defined(&CPU_CONTROL_32BP_ENABLE);
    eval 'sub CPU_CONTROL_32BD_ENABLE () {0x20;}' unless defined(&CPU_CONTROL_32BD_ENABLE);
    eval 'sub CPU_CONTROL_LABT_ENABLE () {0x40;}' unless defined(&CPU_CONTROL_LABT_ENABLE);
    eval 'sub CPU_CONTROL_BEND_ENABLE () {0x80;}' unless defined(&CPU_CONTROL_BEND_ENABLE);
    eval 'sub CPU_CONTROL_SYST_ENABLE () {0x100;}' unless defined(&CPU_CONTROL_SYST_ENABLE);
    eval 'sub CPU_CONTROL_ROM_ENABLE () {0x200;}' unless defined(&CPU_CONTROL_ROM_ENABLE);
    eval 'sub CPU_CONTROL_CPCLK () {0x400;}' unless defined(&CPU_CONTROL_CPCLK);
    eval 'sub CPU_CONTROL_BPRD_ENABLE () {0x800;}' unless defined(&CPU_CONTROL_BPRD_ENABLE);
    eval 'sub CPU_CONTROL_IC_ENABLE () {0x1000;}' unless defined(&CPU_CONTROL_IC_ENABLE);
    eval 'sub CPU_CONTROL_VECRELOC () {0x2000;}' unless defined(&CPU_CONTROL_VECRELOC);
    eval 'sub CPU_CONTROL_ROUNDROBIN () {0x4000;}' unless defined(&CPU_CONTROL_ROUNDROBIN);
    eval 'sub CPU_CONTROL_V4COMPAT () {0x8000;}' unless defined(&CPU_CONTROL_V4COMPAT);
    eval 'sub CPU_CONTROL_FI () {(1<<21);}' unless defined(&CPU_CONTROL_FI);
    eval 'sub CPU_CONTROL_U () {(1<<22);}' unless defined(&CPU_CONTROL_U);
    eval 'sub CPU_CONTROL_VE () {(1<<24);}' unless defined(&CPU_CONTROL_VE);
    eval 'sub CPU_CONTROL_EE () {(1<<25);}' unless defined(&CPU_CONTROL_EE);
    eval 'sub CPU_CONTROL_L2 () {(1<<25);}' unless defined(&CPU_CONTROL_L2);
    eval 'sub CPU_CONTROL_NMFI () {(1<<27);}' unless defined(&CPU_CONTROL_NMFI);
    eval 'sub CPU_CONTROL_TRE () {(1<<28);}' unless defined(&CPU_CONTROL_TRE);
    eval 'sub CPU_CONTROL_AFE () {(1<<29);}' unless defined(&CPU_CONTROL_AFE);
    eval 'sub CPU_CONTROL_TE () {(1<<30);}' unless defined(&CPU_CONTROL_TE);
    eval 'sub CPU_CONTROL_IDC_ENABLE () { &CPU_CONTROL_DC_ENABLE;}' unless defined(&CPU_CONTROL_IDC_ENABLE);
    eval 'sub XSCALE_AUXCTL_K () {0x1;}' unless defined(&XSCALE_AUXCTL_K);
    eval 'sub XSCALE_AUXCTL_P () {0x2;}' unless defined(&XSCALE_AUXCTL_P);
    eval 'sub XSCALE_AUXCTL_MD_WB_RA () {0x;}' unless defined(&XSCALE_AUXCTL_MD_WB_RA);
    eval 'sub XSCALE_AUXCTL_MD_WB_RWA () {0x10;}' unless defined(&XSCALE_AUXCTL_MD_WB_RWA);
    eval 'sub XSCALE_AUXCTL_MD_WT () {0x20;}' unless defined(&XSCALE_AUXCTL_MD_WT);
    eval 'sub XSCALE_AUXCTL_MD_MASK () {0x30;}' unless defined(&XSCALE_AUXCTL_MD_MASK);
    eval 'sub CPU_CT_ISIZE {
        my($x) = @_;
	    eval q((($x) & 0xfff));
    }' unless defined(&CPU_CT_ISIZE);
    eval 'sub CPU_CT_DSIZE {
        my($x) = @_;
	    eval q(((($x) >> 12) & 0xfff));
    }' unless defined(&CPU_CT_DSIZE);
    eval 'sub CPU_CT_S () {(1 << 24);}' unless defined(&CPU_CT_S);
    eval 'sub CPU_CT_CTYPE {
        my($x) = @_;
	    eval q(((($x) >> 25) & 0xf));
    }' unless defined(&CPU_CT_CTYPE);
    eval 'sub CPU_CT_CTYPE_WT () {0;}' unless defined(&CPU_CT_CTYPE_WT);
    eval 'sub CPU_CT_CTYPE_WB1 () {1;}' unless defined(&CPU_CT_CTYPE_WB1);
    eval 'sub CPU_CT_CTYPE_WB2 () {2;}' unless defined(&CPU_CT_CTYPE_WB2);
    eval 'sub CPU_CT_CTYPE_WB6 () {6;}' unless defined(&CPU_CT_CTYPE_WB6);
    eval 'sub CPU_CT_CTYPE_WB7 () {7;}' unless defined(&CPU_CT_CTYPE_WB7);
    eval 'sub CPU_CT_xSIZE_LEN {
        my($x) = @_;
	    eval q((($x) & 0x3));
    }' unless defined(&CPU_CT_xSIZE_LEN);
    eval 'sub CPU_CT_xSIZE_M () {(1 << 2);}' unless defined(&CPU_CT_xSIZE_M);
    eval 'sub CPU_CT_xSIZE_ASSOC {
        my($x) = @_;
	    eval q(((($x) >> 3) & 0x7));
    }' unless defined(&CPU_CT_xSIZE_ASSOC);
    eval 'sub CPU_CT_xSIZE_SIZE {
        my($x) = @_;
	    eval q(((($x) >> 6) & 0x7));
    }' unless defined(&CPU_CT_xSIZE_SIZE);
    eval 'sub FAULT_TYPE_MASK () {0xf;}' unless defined(&FAULT_TYPE_MASK);
    eval 'sub FAULT_USER () {0x10;}' unless defined(&FAULT_USER);
    eval 'sub FAULT_WRTBUF_0 () {0x;}' unless defined(&FAULT_WRTBUF_0);
    eval 'sub FAULT_WRTBUF_1 () {0x2;}' unless defined(&FAULT_WRTBUF_1);
    eval 'sub FAULT_BUSERR_0 () {0x4;}' unless defined(&FAULT_BUSERR_0);
    eval 'sub FAULT_BUSERR_1 () {0x6;}' unless defined(&FAULT_BUSERR_1);
    eval 'sub FAULT_BUSERR_2 () {0x8;}' unless defined(&FAULT_BUSERR_2);
    eval 'sub FAULT_BUSERR_3 () {0xa;}' unless defined(&FAULT_BUSERR_3);
    eval 'sub FAULT_BUSTRNL1 () {0xc;}' unless defined(&FAULT_BUSTRNL1);
    eval 'sub FAULT_BUSTRNL2 () {0xe;}' unless defined(&FAULT_BUSTRNL2);
    eval 'sub FAULT_ALIGN_0 () {0x1;}' unless defined(&FAULT_ALIGN_0);
    eval 'sub FAULT_ALIGN_1 () {0x3;}' unless defined(&FAULT_ALIGN_1);
    eval 'sub FAULT_TRANS_S () {0x5;}' unless defined(&FAULT_TRANS_S);
    eval 'sub FAULT_TRANS_P () {0x7;}' unless defined(&FAULT_TRANS_P);
    eval 'sub FAULT_DOMAIN_S () {0x9;}' unless defined(&FAULT_DOMAIN_S);
    eval 'sub FAULT_DOMAIN_P () {0xb;}' unless defined(&FAULT_DOMAIN_P);
    eval 'sub FAULT_PERM_S () {0xd;}' unless defined(&FAULT_PERM_S);
    eval 'sub FAULT_PERM_P () {0xf;}' unless defined(&FAULT_PERM_P);
    eval 'sub FAULT_IMPRECISE () {0x400;}' unless defined(&FAULT_IMPRECISE);
    eval 'sub ARM_VECTORS_LOW () {0x;}' unless defined(&ARM_VECTORS_LOW);
    eval 'sub ARM_VECTORS_HIGH () {0xffff0000;}' unless defined(&ARM_VECTORS_HIGH);
    eval 'sub INSN_SIZE () {4;}' unless defined(&INSN_SIZE);
    eval 'sub INSN_COND_MASK () {0xf0000000;}' unless defined(&INSN_COND_MASK);
    eval 'sub INSN_COND_AL () {0xe0000000;}' unless defined(&INSN_COND_AL);
}
1;
