require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SH_PARAM_H_)) {
    eval 'sub _SH_PARAM_H_ () {1;}' unless defined(&_SH_PARAM_H_);
    eval 'sub _MACHINE_ARCH () { &sh;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sh";}' unless defined(&MACHINE_ARCH);
    unless(defined(&MID_MACHINE)) {
	eval 'sub MID_MACHINE () { &MID_SH3;}' unless defined(&MID_MACHINE);
    }
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	require 'sh/cpu.ph';
    }
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
    eval 'sub ALIGNBYTES () { &_ALIGNBYTES;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q( &_ALIGN($p));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q( &_ALIGNED_POINTER($p,$t));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub UPAGES () {3;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    if((defined(&UPAGES) ? &UPAGES : undef) == 1) {
	die("too small u-area");
    }
 elsif((defined(&UPAGES) ? &UPAGES : undef) == 2) {
	eval 'sub P1_STACK () {1;}' unless defined(&P1_STACK);
    } else {
	undef(&P1_STACK) if defined(&P1_STACK);
    }
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () { &NBPG;}' unless defined(&MSGBUFSIZE);
    }
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PAGE_SHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PAGE_SHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
}
1;
