/*
 * audio.h
 * Copyright 2009-2011 John Lindgren
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions, and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions, and the following disclaimer in the documentation
 *    provided with the distribution.
 *
 * This software is provided "as is" and without any warranty, express or
 * implied. In no event shall the authors be liable for any damages arising from
 * the use of this software.
 */

#ifndef LIBAUDCORE_AUDIO_H
#define LIBAUDCORE_AUDIO_H

/* 24-bit integer samples are padded to 32-bit; high byte is always 0 */
enum {
 FMT_FLOAT,
 FMT_S8, FMT_U8,
 FMT_S16_LE, FMT_S16_BE, FMT_U16_LE, FMT_U16_BE,
 FMT_S24_LE, FMT_S24_BE, FMT_U24_LE, FMT_U24_BE,
 FMT_S32_LE, FMT_S32_BE, FMT_U32_LE, FMT_U32_BE};

#if 0
#define FMT_S16_NE FMT_S16_BE
#define FMT_U16_NE FMT_U16_BE
#define FMT_S24_NE FMT_S24_BE
#define FMT_U24_NE FMT_U24_BE
#define FMT_S32_NE FMT_S32_BE
#define FMT_U32_NE FMT_U32_BE
#else
#define FMT_S16_NE FMT_S16_LE
#define FMT_U16_NE FMT_U16_LE
#define FMT_S24_NE FMT_S24_LE
#define FMT_U24_NE FMT_U24_LE
#define FMT_S32_NE FMT_S32_LE
#define FMT_U32_NE FMT_U32_LE
#endif

#define FMT_SIZEOF(f) ((f) == FMT_FLOAT ? sizeof (float) : (f) <= FMT_U8 ? 1 : (f) <= FMT_U16_BE ? 2 : 4)

void audio_from_int (const void * in, int format, float * out, int samples);
void audio_to_int (const float * in, void * out, int format, int samples);
void audio_amplify (float * data, int channels, int frames, float * factors);

#endif /* LIBAUDCORE_AUDIO_H */
