1. SL Module

Bogdan Iancu

   FhG FOKUS

Daniel-Constantin Mierla

   asipto.com

   Copyright © 2003 FhG FOKUS
     __________________________________________________________________

   1.1. Overview
   1.2. Parameters

        1.2.1. default_code (int)
        1.2.2. default_reason (str)
        1.2.3. bind_tm (int)

   1.3. Functions

        1.3.1. sl_send_reply(code, reason)
        1.3.2. send_reply(code, reason)
        1.3.3. sl_reply_error()

1.1. Overview

   The SL module allows ser to act as a stateless UA server and generate
   replies to SIP requests without keeping state. That is beneficial in
   many scenarios, in which you wish not to burden server's memory and
   scale well.

   The SL module needs to filter ACKs sent after a local stateless reply
   to an INVITE was generated. To recognize such ACKs, ser adds a special
   "signature" in to-tags. This signature is sought for in incoming ACKs,
   and if included, the ACKs are absorbed.

   To speed up the filtering process, the module uses a timeout mechanism.
   When a reply is sent, a timer us set. As time as the timer is valid,
   The incoming ACK requests will be checked using TO tag value Once the
   timer expires, all the ACK are let through - a long time passed till it
   sent a reply, so it does not expect any ACK that have to be blocked.

   The ACK filtering may fail in some rare cases. If you think these
   matter to you, better use stateful processing (tm module) for INVITE
   processing. Particularly, the problem happens when a UA sends an INVITE
   which already has a to-tag in it (e.g., a re-INVITE) and SER want to
   reply to it. Than, it will keep the current to-tag, which will be
   mirrored in ACK. SER will not see its signature and forward the ACK
   downstream. Caused harm is not bad--just a useless ACK is forwarded.

1.2. Parameters

1.2.1. default_code (int)

   Default reply status code.

   Default value is 500.

   Example 1. default_code example
...
modparam("sl", "default_code", 505)
...

1.2.2. default_reason (str)

   Default reply reason phrase.

   Default value is 'Internal Server Error'.

   Example 2. default_reason example
...
modparam("sl", "default_reason", "Server Error")
...

1.2.3. bind_tm (int)

   Controls if SL module should attempt to bind to TM module in order to
   send stateful reply when the transaction is created.

   Default value is 1 (enabled).

   Example 3. bind_tm example
...
modparam("sl", "bind_tm", 0)  # feature disabled
...

1.3. Functions

1.3.1.  sl_send_reply(code, reason)

   For the current request, a reply is sent back having the given code and
   text reason. The reply is sent stateless, totally independent of the
   Transaction module and with no retransmission for the INVITE's replies.

   Meaning of the parameters is as follows:
     * code - Return code.
     * reason - Reason phrase.

   Example 4. sl_send_reply usage
...
sl_send_reply("404", "Not found");
...

1.3.2.  send_reply(code, reason)

   For the current request, a reply is sent back having the given code and
   text reason. The reply is sent stateful or stateless, depending of the
   TM module: if the transaction for current request is created, then the
   reply is sent stateful, otherwise stateless.

   Meaning of the parameters is as follows:
     * code - Return code.
     * reason - Reason phrase.

   This function can be used from REQUEST_ROUTE, FAILURE_ROUTE,
   BRANCH_ROUTE.

   Example 5. send_reply usage
...
send_reply("404", "Not found");
...
send_reply("403", "Invalid user - $fU");
...

1.3.3.  sl_reply_error()

   Sends back an error reply describing the nature of the last internal
   error. Usually this function should be used after a script function
   that returned an error code.

   Example 6. sl_reply_error usage
...
sl_reply_error();
...
