/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg;

import java.util.ResourceBundle;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.CodecManager;

class JffmpegVideoFormat
extends VideoFormat {
    private static final String RTP_STRING = ".RTP";
    private static final String NATIVE_STRING = ".Native";
    private static final String CLASS_STRING = ".Class";
    private static final String JAVA_CLASS_STRING = ".JavaClass";
    private static final String FFMPEG_NAME = ".FFMpegName";
    private static final String TRUNCATE_STRING = ".IsTruncated";
    private String name;
    ResourceBundle configuration;

    public JffmpegVideoFormat(String string, ResourceBundle resourceBundle) {
        super(string);
        this.name = string;
        this.configuration = resourceBundle;
    }

    public boolean isRtp() {
        return "true".equalsIgnoreCase(this.configuration.getString(this.name + RTP_STRING));
    }

    public boolean isNative() {
        return CodecManager.isNativeAvailable() && "true".equalsIgnoreCase(this.configuration.getString(this.name + NATIVE_STRING));
    }

    public String getCodecClass() {
        return this.configuration.getString(this.name + (this.isNative() ? CLASS_STRING : JAVA_CLASS_STRING));
    }

    public String getFFMpegCodecName() {
        return this.configuration.getString(this.name + FFMPEG_NAME);
    }

    public boolean isTruncated() {
        return "true".equalsIgnoreCase(this.configuration.getString(this.name + TRUNCATE_STRING));
    }
}

