/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.coverage;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class Tokenizer {
    private StringBuffer buffer;
    private Reader reader;
    private char[] buf = new char[20];
    private int peekc;
    private int line = 1;
    private byte[] charTypes = new byte[256];
    private static final byte WHITESPACE = 1;
    private static final byte ALPHA = 4;
    private static final byte QUOTE = 8;
    private int type = -3;
    public static final int TYPE_EOF = -1;
    public static final int TYPE_WORD = -2;
    private static final int TYPE_NOTHING = -3;
    private String value;

    private Tokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(48, 57);
        this.wordChars(46, 46);
        this.wordChars(43, 43);
        this.wordChars(45, 45);
        this.wordChars(95, 95);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.charTypes[34] = 8;
        this.charTypes[39] = 8;
    }

    public Tokenizer(Reader r) {
        this();
        this.reader = r;
    }

    public String getString() {
        return this.value;
    }

    private void wordChars(int low, int hi) {
        while (low <= hi) {
            int n = low++;
            this.charTypes[n] = (byte)(this.charTypes[n] | 4);
        }
    }

    private void whitespaceChars(int low, int hi) {
        while (low <= hi) {
            this.charTypes[low++] = 1;
        }
    }

    private int read() throws IOException {
        int i = this.reader.read();
        if (i != -1) {
            this.append(i);
        }
        return i;
    }

    public void initToken() {
        this.buffer = new StringBuffer();
    }

    public String getToken() {
        this.buffer.setLength(this.buffer.length() - 1);
        return this.buffer.toString();
    }

    private void append(int i) {
        this.buffer.append((char)i);
    }

    public int nextToken() throws IOException {
        int ctype;
        int c;
        byte[] ct = this.charTypes;
        this.value = null;
        if (this.type == -3) {
            c = this.read();
            if (c >= 0) {
                this.type = c;
            }
        } else {
            c = this.peekc;
            if (c < 0) {
                try {
                    c = this.read();
                    if (c >= 0) {
                        this.type = c;
                    }
                }
                catch (EOFException e) {
                    c = -1;
                }
            }
        }
        if (c < 0) {
            this.type = -1;
            return -1;
        }
        int n = ctype = c < 256 ? ct[c] : 4;
        while ((ctype & 1) != 0) {
            if (c == 13) {
                ++this.line;
                c = this.read();
                if (c == 10) {
                    c = this.read();
                }
            } else {
                if (c == 10) {
                    ++this.line;
                }
                c = this.read();
            }
            if (c < 0) {
                this.type = -1;
                return -1;
            }
            ctype = c < 256 ? ct[c] : 4;
        }
        if ((ctype & 4) != 0) {
            this.initToken();
            this.append(c);
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
            } while (((ctype = (c = this.read()) < 0 ? 1 : (c < 256 ? ct[c] : 4)) & 4) != 0);
            this.peekc = c;
            this.value = String.copyValueOf(this.buf, 0, i);
            this.type = -2;
            return -2;
        }
        if ((ctype & 8) != 0) {
            this.initToken();
            this.append(c);
            this.type = c;
            int i = 0;
            this.peekc = this.read();
            while (this.peekc >= 0 && this.peekc != this.type && this.peekc != 10 && this.peekc != 13) {
                if (this.peekc == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                this.peekc = this.read();
                            } else {
                                this.peekc = c2;
                            }
                        } else {
                            this.peekc = c2;
                        }
                    } else {
                        switch (c) {
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                            }
                        }
                        this.peekc = this.read();
                    }
                } else {
                    c = this.peekc;
                    this.peekc = this.read();
                }
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
            }
            if (this.peekc == this.type) {
                this.peekc = this.read();
            }
            this.value = String.copyValueOf(this.buf, 0, i);
            return this.type;
        }
        if (c == 47) {
            c = this.read();
            if (c == 42) {
                int prevc = 0;
                while ((c = this.read()) != 47 || prevc != 42) {
                    if (c == 13) {
                        ++this.line;
                        c = this.read();
                        if (c == 10) {
                            c = this.read();
                        }
                    } else if (c == 10) {
                        ++this.line;
                        c = this.read();
                    }
                    if (c < 0) {
                        this.type = -1;
                        return -1;
                    }
                    prevc = c;
                }
                this.peekc = this.read();
                return this.nextToken();
            }
            if (c == 47) {
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekc = c;
                return this.nextToken();
            }
            this.peekc = c;
            this.type = 47;
            return 47;
        }
        this.peekc = this.read();
        this.type = c;
        return this.type;
    }

    public int getLine() {
        return this.line;
    }
}

