/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.envers.synchronization.work.WorkUnitMergeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeBidirectionalRelationWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Map<String, FakeRelationChange> fakeRelationChanges;
    private final AuditWorkUnit nestedWorkUnit;

    public FakeBidirectionalRelationWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration verCfg, Serializable id, String referencingPropertyName, Object owningEntity, RelationDescription rd, RevisionType revisionType, Object index, AuditWorkUnit nestedWorkUnit) {
        super(sessionImplementor, entityName, verCfg, id);
        this.nestedWorkUnit = nestedWorkUnit;
        this.fakeRelationChanges = new HashMap<String, FakeRelationChange>();
        this.fakeRelationChanges.put(referencingPropertyName, new FakeRelationChange(owningEntity, rd, revisionType, index));
    }

    public FakeBidirectionalRelationWorkUnit(FakeBidirectionalRelationWorkUnit original, Map<String, FakeRelationChange> fakeRelationChanges, AuditWorkUnit nestedWorkUnit) {
        super(original.sessionImplementor, original.entityName, original.verCfg, original.id);
        this.fakeRelationChanges = fakeRelationChanges;
        this.nestedWorkUnit = nestedWorkUnit;
    }

    public FakeBidirectionalRelationWorkUnit(FakeBidirectionalRelationWorkUnit original, AuditWorkUnit nestedWorkUnit) {
        super(original.sessionImplementor, original.entityName, original.verCfg, original.id);
        this.nestedWorkUnit = nestedWorkUnit;
        this.fakeRelationChanges = new HashMap<String, FakeRelationChange>(original.getFakeRelationChanges());
    }

    public AuditWorkUnit getNestedWorkUnit() {
        return this.nestedWorkUnit;
    }

    public Map<String, FakeRelationChange> getFakeRelationChanges() {
        return this.fakeRelationChanges;
    }

    @Override
    public boolean containsWork() {
        return true;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        HashMap<String, Object> nestedData = new HashMap<String, Object>(this.nestedWorkUnit.generateData(revisionData));
        for (FakeRelationChange fakeRelationChange : this.fakeRelationChanges.values()) {
            fakeRelationChange.generateData(this.sessionImplementor, nestedData);
        }
        return nestedData;
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        return FakeBidirectionalRelationWorkUnit.merge(this, this.nestedWorkUnit, second);
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        return FakeBidirectionalRelationWorkUnit.merge(this, this.nestedWorkUnit, second);
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        return this;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        AuditWorkUnit mergedNested = second.getNestedWorkUnit().dispatch(this.nestedWorkUnit);
        Map<String, FakeRelationChange> secondFakeRelationChanges = second.getFakeRelationChanges();
        HashMap<String, FakeRelationChange> mergedFakeRelationChanges = new HashMap<String, FakeRelationChange>();
        HashSet<String> allPropertyNames = new HashSet<String>(this.fakeRelationChanges.keySet());
        allPropertyNames.addAll(secondFakeRelationChanges.keySet());
        for (String propertyName : allPropertyNames) {
            mergedFakeRelationChanges.put(propertyName, FakeRelationChange.merge(this.fakeRelationChanges.get(propertyName), secondFakeRelationChanges.get(propertyName)));
        }
        return new FakeBidirectionalRelationWorkUnit(this, mergedFakeRelationChanges, mergedNested);
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        return first.merge(this);
    }

    public static AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit frwu, AuditWorkUnit nestedFirst, AuditWorkUnit nestedSecond) {
        AuditWorkUnit nestedMerged = nestedSecond.dispatch(nestedFirst);
        return new FakeBidirectionalRelationWorkUnit(frwu, nestedMerged);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeRelationChange {
        private final Object owningEntity;
        private final RelationDescription rd;
        private final RevisionType revisionType;
        private final Object index;

        public FakeRelationChange(Object owningEntity, RelationDescription rd, RevisionType revisionType, Object index) {
            this.owningEntity = owningEntity;
            this.rd = rd;
            this.revisionType = revisionType;
            this.index = index;
        }

        public RevisionType getRevisionType() {
            return this.revisionType;
        }

        public void generateData(SessionImplementor sessionImplementor, Map<String, Object> data) {
            this.rd.getFakeBidirectionalRelationMapper().mapToMapFromEntity(sessionImplementor, data, this.revisionType == RevisionType.DEL ? null : this.owningEntity, null);
            if (this.rd.getFakeBidirectionalRelationIndexMapper() != null) {
                this.rd.getFakeBidirectionalRelationIndexMapper().mapToMapFromEntity(sessionImplementor, data, this.revisionType == RevisionType.DEL ? null : this.index, null);
            }
        }

        public static FakeRelationChange merge(FakeRelationChange first, FakeRelationChange second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            if (first.getRevisionType() == RevisionType.DEL || second.getRevisionType() == RevisionType.ADD) {
                return second;
            }
            return first;
        }
    }
}

