/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.xml;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.extendable.ExtendableItemHelper;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReportParser {
    public Artifact[] getArtifacts(ModuleId moduleId, String conf, File cache) throws ParseException, IOException {
        return this.getArtifacts(this.getReportFile(moduleId, conf, cache));
    }

    private Artifact[] getArtifacts(File report) throws ParseException {
        try {
            SaxXmlReportParser parser = new SaxXmlReportParser(report);
            parser.parse();
            return parser.getArtifacts().toArray(new Artifact[parser.getArtifacts().size()]);
        }
        catch (Exception ex) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + ex.getMessage(), 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    public ModuleRevisionId[] getDependencyRevisionIds(ModuleId moduleId, String conf, File cache) throws ParseException, IOException {
        return this.getDependencyRevisionIds(this.getReportFile(moduleId, conf, cache));
    }

    private ModuleRevisionId[] getDependencyRevisionIds(File report) throws ParseException {
        try {
            SaxXmlReportParser parser = new SaxXmlReportParser(report);
            parser.parse();
            return parser.getModuleRevisionIds().toArray(new ModuleRevisionId[parser.getModuleRevisionIds().size()]);
        }
        catch (Exception ex) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + ex.getMessage(), 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    public ModuleRevisionId[] getRealDependencyRevisionIds(ModuleId moduleId, String conf, File cache) throws ParseException, IOException {
        return this.getRealDependencyRevisionIds(this.getReportFile(moduleId, conf, cache));
    }

    private ModuleRevisionId[] getRealDependencyRevisionIds(File report) throws ParseException {
        try {
            SaxXmlReportParser parser = new SaxXmlReportParser(report);
            parser.parse();
            return parser.getRealModuleRevisionIds().toArray(new ModuleRevisionId[parser.getRealModuleRevisionIds().size()]);
        }
        catch (Exception ex) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + ex.getMessage(), 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    private File getReportFile(ModuleId moduleId, String conf, File cache) {
        File report = new File(cache, XmlReportOutputter.getReportFileName(moduleId, conf));
        if (!report.exists()) {
            throw new IllegalStateException("no report file found for " + moduleId + " " + conf + " in " + cache + ": ivy was looking for " + report);
        }
        return report;
    }

    private static class SaxXmlReportParser {
        private List _mrids;
        private List _defaultMrids;
        private List _realMrids;
        private List _artifacts = new ArrayList();
        private File _report;

        SaxXmlReportParser(File report) {
            this._mrids = new ArrayList();
            this._defaultMrids = new ArrayList();
            this._realMrids = new ArrayList();
            this._report = report;
        }

        public void parse() throws Exception {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(this._report, new DefaultHandler(){
                private String _organisation;
                private String _module;
                private String _branch;
                private String _revision;
                private int _position;
                private Date _pubdate;
                private boolean _skip;
                private ModuleRevisionId _mrid;
                private boolean _default;
                private SortedMap _revisionsMap = new TreeMap();
                private List _revisionArtifacts = null;
                private int _maxPos;

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("module".equals(qName)) {
                        this._organisation = attributes.getValue("organisation");
                        this._module = attributes.getValue("name");
                    } else if ("revision".equals(qName)) {
                        this._revisionArtifacts = new ArrayList();
                        this._branch = attributes.getValue("branch");
                        this._revision = attributes.getValue("name");
                        this._default = Boolean.valueOf(attributes.getValue("default"));
                        String pos = attributes.getValue("position");
                        int n = this._position = pos == null ? this.getMaxPos() + 1 : Integer.valueOf(pos);
                        if (attributes.getValue("error") != null || attributes.getValue("evicted") != null) {
                            this._skip = true;
                        } else {
                            this._revisionsMap.put(new Integer(this._position), this._revisionArtifacts);
                            this._mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._branch, this._revision, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                            SaxXmlReportParser.this._mrids.add(this._mrid);
                            if (this._default) {
                                SaxXmlReportParser.this._defaultMrids.add(this._mrid);
                            } else {
                                SaxXmlReportParser.this._realMrids.add(this._mrid);
                            }
                            try {
                                this._pubdate = Ivy.DATE_FORMAT.parse(attributes.getValue("pubdate"));
                                this._skip = false;
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException("invalid publication date for " + this._organisation + " " + this._module + " " + this._revision + ": " + attributes.getValue("pubdate"));
                            }
                        }
                    } else if ("artifact".equals(qName)) {
                        if (this._skip) {
                            return;
                        }
                        String status = attributes.getValue("status");
                        if (status != null && "failed".equals(status)) {
                            return;
                        }
                        String artifactName = attributes.getValue("name");
                        String type = attributes.getValue("type");
                        String ext = attributes.getValue("ext");
                        DefaultArtifact artifact = new DefaultArtifact(this._mrid, this._pubdate, artifactName, type, ext, ExtendableItemHelper.getExtraAttributes(attributes, "extra-"));
                        this._revisionArtifacts.add(artifact);
                    }
                }

                public void endElement(String uri, String localName, String qname) throws SAXException {
                    if ("dependencies".equals(qname)) {
                        Iterator it = this._revisionsMap.values().iterator();
                        while (it.hasNext()) {
                            List artifacts = (List)it.next();
                            SaxXmlReportParser.this._artifacts.addAll(artifacts);
                        }
                    }
                }

                private int getMaxPos() {
                    return this._revisionsMap.isEmpty() ? -1 : (Integer)this._revisionsMap.keySet().toArray()[this._revisionsMap.size() - 1];
                }
            });
        }

        public List getArtifacts() {
            return this._artifacts;
        }

        public List getModuleRevisionIds() {
            return this._mrids;
        }

        public List getRealModuleRevisionIds() {
            return this._realMrids;
        }
    }
}

