/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.launching.RubyRuntime;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyApplicationShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(ISelection iSelection, String string) {
        Object object = null;
        if (iSelection instanceof IStructuredSelection) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
        }
        if (object == null) {
            this.log("Could not find selection.");
            return;
        }
        IRubyElement iRubyElement = null;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iRubyElement = (IRubyElement)iAdaptable.getAdapter((Class)clazz);
        }
        if (iRubyElement == null) {
            this.log("Selection is not a ruby element.");
            return;
        }
        this.doLaunchWithErrorHandling(iRubyElement, string);
    }

    private void doLaunchWithErrorHandling(IRubyElement iRubyElement, String string) {
        block2: {
            try {
                this.doLaunch(iRubyElement, string);
            }
            catch (CoreException coreException) {
                this.log(coreException);
                IStatus iStatus = coreException.getStatus();
                String string2 = RdtDebugUiMessages.getString("Dialog.launchErrorTitle");
                String string3 = RdtDebugUiMessages.getString("Dialog.launchErrorMessage");
                if (iStatus == null) break block2;
                ErrorDialog.openError((Shell)RdtDebugUiPlugin.getActiveWorkbenchWindow().getShell(), (String)string2, (String)string3, (IStatus)iStatus);
            }
        }
    }

    protected void doLaunch(IRubyElement iRubyElement, String string) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = this.findOrCreateLaunchConfiguration(iRubyElement, string);
        if (iLaunchConfiguration != null) {
            iLaunchConfiguration.launch(string, null);
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IRubyElement iRubyElement;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput == null) {
            this.log("Could not retrieve input from editor: " + iEditorPart.getTitle());
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.rubypeople.rdt.core.IRubyElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iRubyElement = (IRubyElement)iEditorInput.getAdapter((Class)clazz)) == null) {
            this.log("Editor input is not a ruby file or external ruby file.");
            return;
        }
        this.doLaunchWithErrorHandling(iRubyElement, string);
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(IRubyElement iRubyElement, String string) throws CoreException {
        IFile iFile = (IFile)iRubyElement.getUnderlyingResource();
        ILaunchConfigurationType iLaunchConfigurationType = this.getRubyLaunchConfigType();
        ArrayList<ILaunchConfiguration> arrayList = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
        arrayList = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
        int n = 0;
        while (n < iLaunchConfigurationArray.length) {
            boolean bl;
            ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n];
            boolean bl2 = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", "").equals(iFile.getProject().getName());
            if (bl2 && (bl = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.FILE_NAME", "").equals(iFile.getProjectRelativePath().toString()))) {
                arrayList.add(iLaunchConfiguration);
            }
            ++n;
        }
        switch (arrayList.size()) {
            case 0: {
                return this.createConfiguration(iFile);
            }
            case 1: {
                return (ILaunchConfiguration)arrayList.get(0);
            }
        }
        Status status = new Status(2, "org.rubypeople.rdt.debug.ui", 0, RdtDebugUiMessages.getString("LaunchConfigurationShortcut.Ruby.multipleConfigurationsError"), null);
        throw new CoreException((IStatus)status);
    }

    protected ILaunchConfiguration createConfiguration(IFile iFile) {
        if (RubyRuntime.getDefault().getSelectedInterpreter() == null) {
            this.showNoInterpreterDialog();
            return null;
        }
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getRubyLaunchConfigType();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iFile.getName()));
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", iFile.getProject().getName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.FILE_NAME", iFile.getProjectRelativePath().toString());
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", RubyApplicationShortcut.getDefaultWorkingDirectory(iFile.getProject()));
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", RubyRuntime.getDefault().getSelectedInterpreter().getName());
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.rubypeople.rdt.launching.LaunchConfigurationTypeRubyApplication");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void log(String string) {
        RdtDebugUiPlugin.log((IStatus)new Status(1, "org.rubypeople.rdt.debug.ui", 1, string, null));
    }

    protected void log(Throwable throwable) {
        RdtDebugUiPlugin.log(throwable);
    }

    protected void showNoInterpreterDialog() {
        MessageDialog.openInformation((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RdtDebugUiMessages.getString("Dialog.launchWithoutSelectedInterpreter.title"), (String)RdtDebugUiMessages.getString("Dialog.launchWithoutSelectedInterpreter"));
    }

    protected static String getDefaultWorkingDirectory(IProject iProject) {
        if (iProject != null && iProject.exists()) {
            return iProject.getLocation().toOSString();
        }
        return RdtDebugUiPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }
}

