/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;

public class RubyProjectLibraryPage {
    protected RubyProject workingProject;

    protected RubyProjectLibraryPage(RubyProject rubyProject) {
        this.workingProject = rubyProject;
    }

    protected Control getControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        Table table = new Table(composite2, 67618);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.computeSize(-1, -1);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(200);
        tableColumn.setText(RubyUIMessages.getString("RubyProjectLibraryPage.project"));
        CheckboxTableViewer checkboxTableViewer = new CheckboxTableViewer(table);
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                RubyProjectLibraryPage.this.projectCheckedUnchecked(checkStateChangedEvent);
            }
        });
        checkboxTableViewer.setContentProvider(this.getContentProvider());
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        checkboxTableViewer.setInput((Object)this.getWorkspaceProjects());
        checkboxTableViewer.setCheckedElements(this.workingProject.getReferencedProjects().toArray());
        return composite2;
    }

    protected void projectCheckedUnchecked(CheckStateChangedEvent checkStateChangedEvent) {
        IProject iProject = (IProject)checkStateChangedEvent.getElement();
        if (checkStateChangedEvent.getChecked()) {
            this.getWorkingProject().addLoadPathEntry(iProject);
        } else {
            this.getWorkingProject().removeLoadPathEntry(iProject);
        }
    }

    protected RubyProject getWorkingProject() {
        return this.workingProject;
    }

    protected List getWorkspaceProjects() {
        IWorkspaceRoot iWorkspaceRoot = RubyPlugin.getWorkspace().getRoot();
        return Arrays.asList(iWorkspaceRoot.getProjects());
    }

    protected ITableLabelProvider getLabelProvider() {
        ITableLabelProvider iTableLabelProvider = new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                IWorkbench iWorkbench = RubyPlugin.getDefault().getWorkbench();
                return iWorkbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
            }

            public String getColumnText(Object object, int n) {
                if (object instanceof IProject) {
                    return ((IProject)object).getName();
                }
                return RubyUIMessages.getString("RubyProjectLibraryPage.elementNotIProject");
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        };
        return iTableLabelProvider;
    }

    protected IContentProvider getContentProvider() {
        IStructuredContentProvider iStructuredContentProvider = new IStructuredContentProvider(){
            protected List rubyProjects;

            public Object[] getElements(Object object) {
                return this.rubyProjects.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                this.rubyProjects = new ArrayList();
                if (!(object2 instanceof List)) {
                    return;
                }
                Iterator iterator = ((List)object2).iterator();
                while (iterator.hasNext()) {
                    IProject iProject;
                    Object e = iterator.next();
                    if (!(e instanceof IProject) || (iProject = (IProject)e).getName() == RubyProjectLibraryPage.this.workingProject.getProject().getName()) continue;
                    try {
                        if (!iProject.hasNature("org.rubypeople.rdt.core.rubynature")) continue;
                        this.rubyProjects.add(iProject);
                    }
                    catch (CoreException coreException) {}
                }
            }
        };
        return iStructuredContentProvider;
    }
}

