/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchQuery;
import org.eclipse.wst.sse.ui.internal.search.OccurrencesSearchResult;

public class OccurrencesSearchQuery
extends BasicSearchQuery {
    private IStructuredDocument fDocument = null;
    private String fRegionText = null;
    private String fRegionType = null;

    public OccurrencesSearchQuery(IFile file, IStructuredDocument document, String regionText, String regionType) {
        super(file);
        this.fDocument = document;
        this.fRegionText = regionText;
        this.fRegionType = regionType;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return false;
    }

    protected IStatus doQuery() {
        this.clearMatches();
        IStatus status = Status.OK_STATUS;
        FindRegions findRegions = new FindRegions(this.fDocument, this.fRegionText, this.fRegionType);
        try {
            ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)this.getFile());
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)findRegions, markerRule, 1, null);
        }
        catch (CoreException coreException) {
            status = new Status(4, "org.eclipse.wst.sse.ui", 0, "", null);
        }
        return status;
    }

    private String getFilename() {
        String filename = SSEUIMessages.OccurrencesSearchQuery_2;
        if (this.getFile() != null) {
            filename = this.getFile().getName().toString();
        }
        return filename;
    }

    public String getLabel() {
        String label = SSEUIMessages.OccurrencesSearchQuery_0;
        Object[] args = new String[]{this.getSearchText(), this.getOccurrencesCountText(), this.getFilename()};
        return MessageFormat.format(label, args);
    }

    private String getOccurrencesCountText() {
        String count = "";
        return count;
    }

    public ISearchResult getSearchResult() {
        return new OccurrencesSearchResult(this);
    }

    protected String getSearchText() {
        return this.fRegionText;
    }

    private class FindRegions
    implements IWorkspaceRunnable {
        private IStructuredDocument fFindRegionsDocument = null;
        private String fMatchName = null;
        private String fMatchRegionType = null;

        public FindRegions(IStructuredDocument document, String matchText, String matchRegionType) {
            this.fFindRegionsDocument = document;
            this.fMatchName = matchText;
            this.fMatchRegionType = matchRegionType;
        }

        private void findOccurrences(IProgressMonitor monitor) {
            if (!this.isCanceled(monitor)) {
                int matchStart = -1;
                int matchEnd = -1;
                String findRegionText = "";
                ITextRegion r = null;
                ITextRegionList regions = null;
                IStructuredDocumentRegion current = this.fFindRegionsDocument.getFirstStructuredDocumentRegion();
                while (current != null && !this.isCanceled(monitor)) {
                    regions = current.getRegions();
                    int i = 0;
                    while (i < regions.size() && !this.isCanceled(monitor)) {
                        r = regions.get(i);
                        if (r.getType().equals(this.fMatchRegionType) && current.getText(r).equals(this.fMatchName)) {
                            findRegionText = current.getText(r);
                            matchStart = current.getStartOffset(r);
                            matchEnd = matchStart + findRegionText.trim().length();
                            OccurrencesSearchQuery.this.addMatch((IDocument)this.fFindRegionsDocument, matchStart, matchEnd);
                        }
                        ++i;
                    }
                    current = current.getNext();
                }
            }
        }

        private boolean isCanceled(IProgressMonitor monitor) {
            return monitor != null && monitor.isCanceled();
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                this.findOccurrences(monitor);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }
}

