/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.hash.Sha160;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.SecureRandom;

public class FIPS186 {
    public static final int DSA_PARAMS_SEED = 0;
    public static final int DSA_PARAMS_COUNTER = 1;
    public static final int DSA_PARAMS_Q = 2;
    public static final int DSA_PARAMS_P = 3;
    public static final int DSA_PARAMS_E = 4;
    public static final int DSA_PARAMS_G = 5;
    private static final BigInteger TWO = BigInteger.valueOf(2);
    private static final BigInteger TWO_POW_160 = TWO.pow(160);
    private Sha160 sha;
    private int L;
    private SecureRandom rnd;
    private PRNG prng;

    private /* synthetic */ void finit$() {
        this.sha = new Sha160();
        this.rnd = null;
        this.prng = null;
    }

    public FIPS186(int n, SecureRandom secureRandom) {
        this.finit$();
        this.L = n;
        this.rnd = secureRandom;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BigInteger[] generateParameters() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        int n;
        BigInteger bigInteger6;
        BigInteger bigInteger7;
        byte[] byArray = new byte[20];
        int n2 = (this.L - 1) % 160;
        int n3 = (this.L - 1 - n2) / 160;
        BigInteger[] bigIntegerArray = new BigInteger[n3 + 1];
        block6: while (true) {
            byte[] byArray2;
            byte[] byArray3;
            this.nextRandomBytes(byArray);
            bigInteger7 = new BigInteger(1, byArray).setBit(159).setBit(0);
            BigInteger bigInteger8 = bigInteger7.add(BigInteger.ONE).mod(TWO_POW_160);
            Sha160 sha160 = this.sha;
            // MONITORENTER : sha160
            try {
                byArray3 = bigInteger7.toByteArray();
                this.sha.update(byArray3, 0, byArray3.length);
                byArray3 = this.sha.digest();
                byArray2 = bigInteger8.toByteArray();
                this.sha.update(byArray2, 0, byArray2.length);
                byArray2 = this.sha.digest();
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                // MONITOREXIT : sha160
                throw throwable;
            }
            Object var21_20 = null;
            // MONITOREXIT : sha160
            for (int i = 0; i < byArray3.length; ++i) {
                int n4 = i;
                byArray3[n4] = byArray3[n4] ^ byArray2[i];
            }
            BigInteger bigInteger9 = new BigInteger(1, byArray3);
            bigInteger6 = bigInteger9.setBit(159).setBit(0);
            if (!bigInteger6.isProbablePrime(80)) continue;
            n = 0;
            int n5 = 2;
            do {
                BigInteger bigInteger10;
                int n6;
                BigInteger bigInteger11 = BigInteger.valueOf((long)n5 & 0xFFFFFFFFL);
                BigInteger bigInteger12 = bigInteger7.add(bigInteger11);
                Sha160 sha1602 = this.sha;
                // MONITORENTER : sha1602
                try {
                    for (n6 = 0; n6 <= n3; ++n6) {
                        byArray3 = bigInteger12.add(BigInteger.valueOf((long)n6 & 0xFFFFFFFFL)).mod(TWO_POW_160).toByteArray();
                        this.sha.update(byArray3, 0, byArray3.length);
                        bigIntegerArray[n6] = new BigInteger(1, this.sha.digest());
                    }
                    Object var22_26 = null;
                }
                catch (Throwable throwable) {
                    Object var22_27 = null;
                    // MONITOREXIT : sha1602
                    throw throwable;
                }
                BigInteger bigInteger13 = bigIntegerArray[0];
                for (n6 = 1; n6 < n3; bigInteger13 = bigInteger13.add(bigIntegerArray[n6].multiply(TWO.pow(n6 * 160))), ++n6) {
                }
                BigInteger bigInteger14 = (bigInteger13 = bigInteger13.add(bigIntegerArray[n3].mod(TWO.pow(n2)).multiply(TWO.pow(n3 * 160)))).add(TWO.pow(this.L - 1));
                bigInteger5 = bigInteger14.subtract((bigInteger10 = bigInteger14.mod(TWO.multiply(bigInteger6))).subtract(BigInteger.ONE));
                if (bigInteger5.compareTo(TWO.pow(this.L - 1)) >= 0 && bigInteger5.isProbablePrime(80)) {
                    bigInteger4 = bigInteger5.subtract(BigInteger.ONE).divide(bigInteger6);
                    bigInteger3 = TWO;
                    bigInteger2 = bigInteger5.subtract(BigInteger.ONE);
                    bigInteger = TWO;
                    break block6;
                }
                n5 += n3 + 1;
            } while (++n < 4096);
        }
        while (bigInteger3.compareTo(bigInteger2) < 0 && (bigInteger = bigInteger3.modPow(bigInteger4, bigInteger5)).equals(BigInteger.ONE)) {
            bigInteger3 = bigInteger3.add(BigInteger.ONE);
        }
        return new BigInteger[]{bigInteger7, BigInteger.valueOf(n), bigInteger6, bigInteger5, bigInteger4, bigInteger};
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

