/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType {
    private static final long serialVersionUID = -5366242454346948798L;
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient Integer hashCode;
    private transient String string;

    public CompositeType(String string, String string2, String[] stringArray, String[] stringArray2, OpenType[] openTypeArray) throws OpenDataException {
        super(CompositeType.class$("javax.management.openmbean.CompositeData").getName(), string, string2);
        int n;
        if (stringArray.length == 0 || stringArray.length != stringArray2.length || stringArray.length != openTypeArray.length) {
            throw new IllegalArgumentException("Arrays must be non-empty and of equal size.");
        }
        this.nameToDescription = new TreeMap();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("Name " + n + " is null.");
            }
            if (stringArray2[n] == null) {
                throw new IllegalArgumentException("Description " + n + " is null.");
            }
            String string3 = stringArray[n].trim();
            if (string3.length() == 0) {
                throw new IllegalArgumentException("Name " + n + " is " + "the empty string.");
            }
            if (stringArray2[n].length() == 0) {
                throw new IllegalArgumentException("Description " + n + " is " + "the empty string.");
            }
            if (this.nameToDescription.containsKey(string3)) {
                throw new OpenDataException(string3 + " appears more " + "than once.");
            }
            this.nameToDescription.put(string3, stringArray2[n]);
        }
        this.nameToType = new TreeMap();
        for (n = 0; n < stringArray.length; ++n) {
            this.nameToType.put(stringArray[n].trim(), openTypeArray[n]);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean containsKey(String string) {
        return this.nameToDescription.containsKey(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeType)) {
            return false;
        }
        CompositeType compositeType = (CompositeType)object;
        if (!compositeType.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        Set set = this.keySet();
        if (!compositeType.keySet().equals(set)) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (compositeType.getType(string).equals(this.getType(string))) continue;
            return false;
        }
        return true;
    }

    public String getDescription(String string) {
        return (String)this.nameToDescription.get(string);
    }

    public OpenType getType(String string) {
        return (OpenType)this.nameToType.get(string);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int n = 0;
            Iterator iterator = this.nameToType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                n += entry.getKey().hashCode() + entry.getValue().hashCode();
            }
            this.hashCode = n + this.getTypeName().hashCode();
        }
        return this.hashCode;
    }

    public boolean isValue(Object object) {
        if (object instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)object;
            return this.equals(compositeData.getCompositeType());
        }
        return false;
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getTypeName() + ", fields=" + this.nameToType + "]";
        }
        return this.string;
    }
}

