/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class X509CRL
extends CRL
implements X509Extension {
    protected X509CRL() {
        super("X.509");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object other) {
        if (!(other instanceof X509CRL)) return false;
        try {
            X509CRL x = (X509CRL)other;
            if (this.getEncoded().length != x.getEncoded().length) {
                return false;
            }
            byte[] b1 = this.getEncoded();
            byte[] b2 = x.getEncoded();
            int i = 0;
            while (true) {
                if (i >= b1.length) {
                    return true;
                }
                if (b1[i] != b2[i]) {
                    return false;
                }
                ++i;
            }
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public abstract Set<? extends X509CRLEntry> getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public X500Principal getIssuerX500Principal() {
        throw new UnsupportedOperationException();
    }
}

