/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSet<T>
extends AbstractSet<T>
implements NavigableSet<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143000061671589L;
    private transient NavigableMap<T, String> map;

    public TreeSet() {
        this.map = new TreeMap<T, String>();
    }

    public TreeSet(Comparator<? super T> comparator) {
        this.map = new TreeMap<T, String>(comparator);
    }

    public TreeSet(Collection<? extends T> collection) {
        this.map = new TreeMap<T, String>();
        this.addAll(collection);
    }

    public TreeSet(SortedSet<T> sortedSet) {
        this.map = new TreeMap<T, String>(sortedSet.comparator());
        Iterator itr = sortedSet.iterator();
        ((TreeMap)this.map).putKeysLinear(itr, sortedSet.size());
    }

    private TreeSet(NavigableMap<T, String> backingMap) {
        this.map = backingMap;
    }

    @Override
    public boolean add(T obj) {
        return this.map.put(obj, "") == null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        int pos = c.size();
        Iterator<T> itr = c.iterator();
        while (--pos >= 0) {
            result |= this.map.put(itr.next(), "") == null;
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet copy = null;
        try {
            copy = (TreeSet)super.clone();
            copy.map = (NavigableMap)((AbstractMap)((Object)this.map)).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return copy;
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.map.comparator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    @Override
    public T first() {
        return (T)this.map.firstKey();
    }

    @Override
    public SortedSet<T> headSet(T to) {
        return this.headSet(to, false);
    }

    @Override
    public NavigableSet<T> headSet(T to, boolean inclusive) {
        return new TreeSet<T>(this.map.headMap(to, inclusive));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public T last() {
        return (T)this.map.lastKey();
    }

    @Override
    public boolean remove(Object obj) {
        return this.map.remove(obj) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public SortedSet<T> subSet(T from, T to) {
        return this.subSet(from, true, to, false);
    }

    @Override
    public NavigableSet<T> subSet(T from, boolean fromInclusive, T to, boolean toInclusive) {
        return new TreeSet<T>(this.map.subMap(from, fromInclusive, to, toInclusive));
    }

    @Override
    public SortedSet<T> tailSet(T from) {
        return this.tailSet(from, true);
    }

    @Override
    public NavigableSet<T> tailSet(T from, boolean inclusive) {
        return new TreeSet<T>(this.map.tailMap(from, inclusive));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Iterator itr = this.map.keySet().iterator();
        int pos = this.map.size();
        s.writeObject(this.map.comparator());
        s.writeInt(pos);
        while (--pos >= 0) {
            s.writeObject(itr.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Comparator comparator = (Comparator)s.readObject();
        int size = s.readInt();
        this.map = new TreeMap<T, String>(comparator);
        ((TreeMap)this.map).putFromObjStream(s, size, false);
    }

    @Override
    public T ceiling(T e) {
        return this.map.ceilingKey(e);
    }

    @Override
    public Iterator<T> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public NavigableSet<T> descendingSet() {
        return this.map.descendingKeySet();
    }

    @Override
    public T floor(T e) {
        return this.map.floorKey(e);
    }

    @Override
    public T higher(T e) {
        return this.map.higherKey(e);
    }

    @Override
    public T lower(T e) {
        return this.map.lowerKey(e);
    }

    @Override
    public T pollFirst() {
        return this.map.pollFirstEntry().getKey();
    }

    @Override
    public T pollLast() {
        return this.map.pollLastEntry().getKey();
    }
}

