#!/bin/sh
echo 'name: crypto-api
version: 0.8
id: crypto-api-0.8-05b728f3d677abca6e90bce525286739

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
import-dirs: /usr/local/lib/ghc/crypto-api-0.8
library-dirs: /usr/local/lib/ghc/crypto-api-0.8
hs-libraries: HScrypto-api-0.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-143060371bda4ff52c270d1067551fe8
         base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         cereal-0.3.0.0-c17ac2a70f89323d10af6f3ac87760ec
         entropy-0.2.1-de629404e9cf90edf577cc323c76bad0
         largeword-1.0.0-c39497709d633542d290e92c0c11e3a4
         tagged-0.2-4db34a1a28b200ea54bef8eab1247bdb
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.8/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
