#!/bin/sh
echo 'name: tagsoup
version: 0.12.4
id: tagsoup-0.12.4-933548e2cdca1bad57d5a71fae2a206a

license: BSD3
copyright: Neil Mitchell 2006-2011
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/tagsoup/
package-url:
description: TagSoup is a library for parsing HTML/XML. It supports the HTML 5 specification,
             and can be used to parse either well-formed XML, or unstructured and malformed HTML
             from the web. The library also provides useful functions to extract information
             from an HTML document, making it ideal for screen-scraping.
             .
             Users should start from the "Text.HTML.TagSoup" module.
category: XML
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: textproc/hs-tagsoup
exposed: True
exposed-modules: Text.HTML.Download Text.HTML.TagSoup
                 Text.HTML.TagSoup.Entity Text.HTML.TagSoup.Match
                 Text.HTML.TagSoup.Tree Text.StringLike
hidden-modules: Text.HTML.TagSoup.Generated
                Text.HTML.TagSoup.Implementation Text.HTML.TagSoup.Manual
                Text.HTML.TagSoup.Options Text.HTML.TagSoup.Parser
                Text.HTML.TagSoup.Render Text.HTML.TagSoup.Specification
                Text.HTML.TagSoup.Type
import-dirs: /usr/local/lib/ghc/tagsoup-0.12.4
library-dirs: /usr/local/lib/ghc/tagsoup-0.12.4
hs-libraries: HStagsoup-0.12.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         network-2.3.0.5-435de5913c7c66da653cc03396522a6b
         text-0.11.1.5-24dbc1ca0a1252804bf8bef893d5cf9c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tagsoup-0.12.4/html/tagsoup.haddock
haddock-html: /usr/local/share/doc/hs-tagsoup-0.12.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
