#!/bin/sh
echo 'name: tls
version: 0.8.1
id: tls-0.8.1-565e5b27dfacbb1b1dab0c4cd26b52db

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
description: Native Haskell TLS and SSL protocol implementation for server and client.
             .
             This provides a high-level implementation of a sensitive security protocol,
             eliminating a common set of security issues through the use of the advanced
             type system, high level constructions and common Haskell features.
             .
             Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
             with only RSA supported for Key Exchange.
             .
             Only core protocol available here, have a look at the
             <http://hackage.haskell.org/package/tls-extra/> package for default
             ciphers, compressions and certificates functions.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS Network.TLS.Cipher
                 Network.TLS.Compression Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.MAC
                Network.TLS.Core Network.TLS.Crypto Network.TLS.Packet
                Network.TLS.Record Network.TLS.State Network.TLS.Sending
                Network.TLS.Receiving Network.TLS.Util Network.TLS.Wire
import-dirs: /usr/local/lib/ghc/tls-0.8.1
library-dirs: /usr/local/lib/ghc/tls-0.8.1
hs-libraries: HStls-0.8.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         cereal-0.3.0.0-c17ac2a70f89323d10af6f3ac87760ec
         certificate-0.9.5-796feccb6e5570e05bd1be52eac27f6c
         crypto-api-0.8-05b728f3d677abca6e90bce525286739
         cryptocipher-0.2.8-de34d953cac7c0b2caa7d22301193960
         cryptohash-0.7.0-f59ea148ba6fadfd32d16c0b11e0bb1f
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.8.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.8.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
