/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.applet.PluginAppletViewer;

public class PluginCookieManager
extends CookieManager {
    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap cookieMap = new HashMap();
        String cookies = (String)PluginAppletViewer.requestPluginCookieInfo(uri);
        ArrayList<String> cookieHeader = new ArrayList<String>();
        if (cookies != null && cookies.length() > 0) {
            cookieHeader.add(cookies);
        }
        for (HttpCookie cookie : this.getCookieStore().get(uri)) {
            if (!this.pathMatches(uri.getPath(), cookie.getPath())) continue;
            cookieHeader.add(cookie.toString());
        }
        cookieMap.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(cookieMap);
    }

    private boolean pathMatches(String path, String pathToMatchWith) {
        if (path == pathToMatchWith) {
            return true;
        }
        if (path == null || pathToMatchWith == null) {
            return false;
        }
        return path.startsWith(pathToMatchWith);
    }
}

