/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class JNLPSplashScreen
extends JDialog {
    String applicationTitle;
    String applicationVendor;
    ResourceTracker resourceTracker;
    URL splashImageUrl;
    Image splashImage;

    public JNLPSplashScreen(ResourceTracker resourceTracker, String applicationTitle, String applicationVendor) {
        this.resourceTracker = resourceTracker;
        this.applicationTitle = applicationTitle;
        this.applicationVendor = applicationVendor;
    }

    public void setSplashImageURL(URL url) {
        this.splashImageUrl = url;
        this.splashImage = null;
        try {
            this.splashImage = ImageIO.read(this.resourceTracker.getCacheFile(this.splashImageUrl));
            if (this.splashImage == null) {
                if (JNLPRuntime.isDebug()) {
                    System.err.println("Error loading splash image: " + url);
                }
                return;
            }
        }
        catch (IOException e) {
            if (JNLPRuntime.isDebug()) {
                System.err.println("Error loading splash image: " + url);
            }
            this.splashImage = null;
            return;
        }
        catch (IllegalArgumentException argumentException) {
            if (JNLPRuntime.isDebug()) {
                System.err.println("Error loading splash image: " + url);
            }
            this.splashImage = null;
            return;
        }
        this.correctSize();
    }

    public boolean isSplashScreenValid() {
        return this.splashImage != null;
    }

    private void correctSize() {
        Insets insets = this.getInsets();
        int minimumWidth = this.splashImage.getWidth(null) + insets.left + insets.right;
        int minimumHeight = this.splashImage.getHeight(null) + insets.top + insets.bottom;
        this.setMinimumSize(new Dimension(minimumWidth, minimumHeight));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - minimumWidth) / 2, (screenSize.height - minimumHeight) / 2);
    }

    @Override
    public void paint(Graphics g) {
        if (this.splashImage == null) {
            return;
        }
        this.correctSize();
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.splashImage, this.getInsets().left, this.getInsets().top, null);
    }
}

