/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.actions.AbstractFileProcessor;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightFactory;
import com.maddyhome.idea.copyright.util.FileTypeUtil;

public class UpdateCopyrightProcessor
extends AbstractFileProcessor {
    private Project project;
    private Module module;
    private static final String TITLE = "Update Copyright";
    private static final String MESSAGE = "Updating copyrights...";
    private static final Logger logger = Logger.getInstance((String)UpdateCopyrightProcessor.class.getName());

    public UpdateCopyrightProcessor(Project project, Module module) {
        super(project, module, TITLE, MESSAGE);
        this.setup(project, module);
    }

    public UpdateCopyrightProcessor(Project project, Module module, PsiDirectory dir, boolean subdirs) {
        super(project, dir, subdirs, TITLE, MESSAGE);
        this.setup(project, module);
    }

    public UpdateCopyrightProcessor(Project project, Module module, PsiFile file) {
        super(project, file, TITLE, MESSAGE);
        this.setup(project, module);
    }

    public UpdateCopyrightProcessor(Project project, Module module, PsiFile[] files) {
        super(project, files, TITLE, MESSAGE, null);
        this.setup(project, module);
    }

    @Override
    protected Runnable preprocessFile(PsiFile file) throws IncorrectOperationException {
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return EmptyRunnable.getInstance();
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText2(vfile.getPresentableUrl());
        }
        Module mod = this.module;
        if (this.module == null) {
            mod = ProjectRootManager.getInstance((Project)this.project).getFileIndex().getModuleForFile(vfile);
        }
        if (mod == null) {
            return EmptyRunnable.getInstance();
        }
        CopyrightProfile opts = CopyrightManager.getInstance(this.project).getCopyrightOptions(file);
        if (opts != null && FileTypeUtil.getInstance().isSupportedFile(file)) {
            logger.debug("process " + file);
            final UpdateCopyright update = UpdateCopyrightFactory.createUpdateCopyright(this.project, mod, file, opts);
            if (update == null) {
                return EmptyRunnable.getInstance();
            }
            update.prepare();
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        update.complete();
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            };
        }
        return EmptyRunnable.getInstance();
    }

    private void setup(Project project, Module module) {
        this.project = project;
        this.module = module;
    }
}

