/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nullable;

public class TestNGInClassConfigurationProducer
extends TestNGConfigurationProducer {
    private PsiElement myPsiElement = null;

    public PsiElement getSourceElement() {
        return this.myPsiElement;
    }

    @Nullable
    protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
        PsiClass psiClass = null;
        for (PsiElement element = location.getPsiElement(); element != null; element = element.getParent()) {
            PsiClass[] classes;
            if (element instanceof PsiClass) {
                psiClass = (PsiClass)element;
                break;
            }
            if (element instanceof PsiMember) {
                psiClass = ((PsiMember)element).getContainingClass();
                break;
            }
            if (!(element instanceof PsiClassOwner) || (classes = ((PsiClassOwner)element).getClasses()).length != 1) continue;
            psiClass = classes[0];
            break;
        }
        if (psiClass == null || !PsiClassUtil.isRunnableClass(psiClass, (boolean)true) || !TestNGUtil.hasTest((PsiModifierListOwner)psiClass)) {
            return null;
        }
        this.myPsiElement = psiClass;
        Project project = location.getProject();
        RunnerAndConfigurationSettingsImpl settings = this.cloneTemplateConfiguration(project, context);
        TestNGConfiguration configuration = (TestNGConfiguration)settings.getConfiguration();
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.setClassConfiguration(psiClass);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location.getPsiElement(), PsiMethod.class, (boolean)false);
        if (method != null && TestNGUtil.hasTest((PsiModifierListOwner)method)) {
            configuration.setMethodConfiguration((Location<PsiMethod>)PsiLocation.fromPsiElement((Project)project, (PsiElement)method));
            this.myPsiElement = method;
        }
        configuration.restoreOriginalModule(originalModule);
        settings.setName(configuration.getName());
        this.copyStepsBeforeRun(project, (RunConfiguration)configuration);
        RunConfigurationExtension.patchCreatedConfiguration((ModuleBasedConfiguration)configuration);
        return settings;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

