/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.CheckArea;
import com.intellij.spellchecker.quickfixes.AcceptWordAsCorrect;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.RenameTo;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Token;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.containers.hash.HashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckingInspection
extends LocalInspectionTool {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";
    private static final AcceptWordAsCorrect BATCH_ACCEPT_FIX = new AcceptWordAsCorrect();
    private static final SpellCheckerQuickFix[] BATCH_FIXES = new SpellCheckerQuickFix[]{BATCH_ACCEPT_FIX};
    private static final Map<Language, SpellcheckingStrategy> factories = new HashMap();
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = SpellCheckerBundle.message("spelling", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/SpellCheckingInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = SpellCheckerBundle.message("spellchecking.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/SpellCheckingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SPELL_CHECKING_INSPECTION_TOOL_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/SpellCheckingInspection.getShortName must not return null");
        }
        return SPELL_CHECKING_INSPECTION_TOOL_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = SpellCheckerManager.getHighlightDisplayLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/SpellCheckingInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureFactoriesAreLoaded() {
        Map<Language, SpellcheckingStrategy> map = factories;
        synchronized (map) {
            if (!factories.isEmpty()) {
                return;
            }
            SpellcheckingStrategy[] spellcheckingStrategies = (SpellcheckingStrategy[])Extensions.getExtensions(SpellcheckingStrategy.EP_NAME);
            if (spellcheckingStrategies != null) {
                for (SpellcheckingStrategy spellcheckingStrategy : spellcheckingStrategies) {
                    Language language = spellcheckingStrategy.getLanguage();
                    if (language == Language.ANY) continue;
                    factories.put(language, spellcheckingStrategy);
                }
            }
        }
    }

    private static SpellcheckingStrategy getFactoryByLanguage(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.getFactoryByLanguage must not be null");
        }
        return factories.containsKey(lang) ? factories.get(lang) : factories.get(PlainTextLanguage.INSTANCE);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.buildVisitor must not be null");
        }
        final SpellCheckerManager manager = SpellCheckerManager.getInstance(holder.getProject());
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){
            private final NamesValidator[] NAMES_VALIDATORS = SpellCheckingInspection.getNamesValidators();
            {
                SpellCheckingInspection.ensureFactoriesAreLoaded();
            }

            public void visitElement(PsiElement element) {
                ASTNode node = element.getNode();
                if (node == null) {
                    return;
                }
                Language language = element.getLanguage();
                IElementType elementType = node.getElementType();
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (parserDefinition != null && (parserDefinition.getStringLiteralElements().contains(elementType) ? !SpellCheckingInspection.this.processLiterals : (parserDefinition.getCommentTokens().contains(elementType) ? !SpellCheckingInspection.this.processComments : !SpellCheckingInspection.this.processCode))) {
                    return;
                }
                Token[] tokens = SpellCheckingInspection.tokenize(element, language);
                if (tokens == null) {
                    return;
                }
                THashSet alreadyChecked = new THashSet();
                for (Token token : tokens) {
                    SpellCheckingInspection.inspect(token, holder, isOnTheFly, (Set)alreadyChecked, manager, this.NAMES_VALIDATORS);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/inspections/SpellCheckingInspection.buildVisitor must not return null");
        }
        return psiElementVisitor;
    }

    @Nullable
    public static Token[] tokenize(@NotNull PsiElement element, @NotNull Language language) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.tokenize must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.tokenize must not be null");
        }
        SpellcheckingStrategy factoryByLanguage = SpellCheckingInspection.getFactoryByLanguage(language);
        Tokenizer tokenizer = factoryByLanguage.getTokenizer(element);
        return tokenizer.tokenize(element);
    }

    private static void inspect(Token token, ProblemsHolder holder, boolean isOnTheFly, @NotNull Set<String> alreadyChecked, @NotNull SpellCheckerManager manager, NamesValidator ... validators) {
        if (alreadyChecked == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.inspect must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.inspect must not be null");
        }
        List<CheckArea> areaList = token.getAreas();
        if (areaList == null) {
            return;
        }
        for (CheckArea area : areaList) {
            boolean hasProblems;
            boolean keyword;
            String word;
            boolean ignored = area.isIgnored();
            TextRange textRange = area.getTextRange();
            if (ignored || textRange == null || (word = area.getWord()) == null || !isOnTheFly && alreadyChecked.contains(word) || (keyword = SpellCheckingInspection.isKeyword(validators, token.getElement(), word)) || !(hasProblems = manager.hasProblem(word))) continue;
            if (!isOnTheFly) {
                alreadyChecked.add(word);
                SpellCheckingInspection.addBatchDescriptor(textRange, token, holder);
                continue;
            }
            SpellCheckingInspection.addRegularDescriptor(textRange, token, holder);
        }
    }

    private static void addBatchDescriptor(@NotNull TextRange textRange, @NotNull Token token, @NotNull ProblemsHolder holder) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.addBatchDescriptor must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.addBatchDescriptor must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.addBatchDescriptor must not be null");
        }
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(token, holder, textRange, BATCH_FIXES, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void addRegularDescriptor(@NotNull TextRange textRange, @NotNull Token token, @NotNull ProblemsHolder holder) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.addRegularDescriptor must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.addRegularDescriptor must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/spellchecker/inspections/SpellCheckingInspection.addRegularDescriptor must not be null");
        }
        SpellCheckerQuickFix[] fixes = new SpellCheckerQuickFix[]{token.isUseRename() ? new RenameTo() : new ChangeTo(), new AcceptWordAsCorrect()};
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(token, holder, textRange, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(Token token, ProblemsHolder holder, TextRange textRange, SpellCheckerQuickFix[] fixes, boolean onTheFly) {
        String defaultDescription = SpellCheckerBundle.message("typo.in.word.ref", new Object[0]);
        String tokenDescription = token.getDescription();
        String description = tokenDescription == null ? defaultDescription : tokenDescription;
        TextRange highlightRange = TextRange.from((int)(token.getOffset() + textRange.getStartOffset()), (int)textRange.getLength());
        assert (highlightRange.getStartOffset() >= 0) : token.getText();
        ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor(token.getElement(), highlightRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), (LocalQuickFix[])fixes);
        if (onTheFly) {
            for (SpellCheckerQuickFix fix : fixes) {
                fix.setDescriptor(problemDescriptor);
            }
        }
        return problemDescriptor;
    }

    @Nullable
    public static NamesValidator[] getNamesValidators() {
        Object[] extensions = Extensions.getExtensions((String)"com.intellij.lang.namesValidator");
        NamesValidator[] validators = null;
        if (extensions != null) {
            ArrayList<NamesValidator> validatorList = new ArrayList<NamesValidator>();
            for (Object extension : extensions) {
                if (!(extension instanceof LanguageExtensionPoint) || !(((LanguageExtensionPoint)extension).getInstance() instanceof NamesValidator)) continue;
                validatorList.add((NamesValidator)((LanguageExtensionPoint)extension).getInstance());
            }
            if (validatorList.size() > 0) {
                validators = new NamesValidator[validatorList.size()];
                validatorList.toArray(validators);
            }
        }
        return validators;
    }

    public static boolean isKeyword(NamesValidator[] validators, PsiElement element, String word) {
        if (validators == null) {
            return false;
        }
        for (NamesValidator validator : validators) {
            if (!validator.isKeyword(word, element.getProject())) continue;
            return true;
        }
        return false;
    }

    public JComponent createOptionsPanel() {
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.code", new Object[0]), (InspectionProfileEntry)this, "processCode"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.literals", new Object[0]), (InspectionProfileEntry)this, "processLiterals"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.comments", new Object[0]), (InspectionProfileEntry)this, "processComments"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)verticalBox, "North");
        return panel;
    }
}

