/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.property;

import hidden.org.apache.jackrabbit.webdav.property.DavPropertyName;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import hidden.org.apache.jackrabbit.webdav.property.PropContainer;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Element;

public class DavPropertyNameSet
extends PropContainer {
    private static Logger log = LoggerFactory.getLogger(DavPropertyNameSet.class);
    private final HashSet set = new HashSet();

    public DavPropertyNameSet() {
    }

    public DavPropertyNameSet(DavPropertyNameSet initialSet) {
        this.addAll(initialSet);
    }

    public DavPropertyNameSet(Element propElement) {
        if (!DomUtil.matches(propElement, "prop", NAMESPACE)) {
            throw new IllegalArgumentException("'DAV:prop' element expected.");
        }
        ElementIterator it = DomUtil.getChildren(propElement);
        while (it.hasNext()) {
            this.add(DavPropertyName.createFromXml(it.nextElement()));
        }
    }

    public boolean add(DavPropertyName propertyName) {
        return this.set.add(propertyName);
    }

    public boolean addAll(DavPropertyNameSet propertyNames) {
        return this.set.addAll(propertyNames.getContent());
    }

    public boolean remove(DavPropertyName propertyName) {
        return this.set.remove(propertyName);
    }

    public DavPropertyNameIterator iterator() {
        return new PropertyNameIterator();
    }

    public boolean contains(DavPropertyName name) {
        return this.set.contains(name);
    }

    public boolean addContent(Object contentEntry) {
        if (contentEntry instanceof DavPropertyName) {
            return this.add((DavPropertyName)contentEntry);
        }
        log.debug("DavPropertyName object expected. Found: " + contentEntry.getClass().toString());
        return false;
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int getContentSize() {
        return this.set.size();
    }

    public Collection getContent() {
        return this.set;
    }

    private class PropertyNameIterator
    implements DavPropertyNameIterator {
        private Iterator iter;

        private PropertyNameIterator() {
            this.iter = DavPropertyNameSet.this.set.iterator();
        }

        public DavPropertyName nextPropertyName() {
            return (DavPropertyName)this.iter.next();
        }

        public void remove() {
            this.iter.remove();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }
    }
}

