/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.LimitedPool;
import com.intellij.util.io.FinalizationRequest;
import com.intellij.util.io.PoolPageKey;
import com.intellij.util.io.RandomAccessDataFile;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.jetbrains.annotations.Nullable;

public class Page {
    public static final int PAGE_SIZE = 4096;
    private static final LimitedPool<ByteBuffer> ourBufferPool = new LimitedPool<ByteBuffer>(10, new LimitedPool.ObjectFactory<ByteBuffer>(){

        @Override
        public ByteBuffer create() {
            return ByteBuffer.allocate(4096);
        }

        @Override
        public void cleanup(ByteBuffer byteBuffer) {
        }
    });
    private final long offset;
    private final RandomAccessDataFile owner;
    private final PoolPageKey myKey;
    private ByteBuffer buf;
    private boolean read = false;
    private boolean dirty = false;
    private int myFinalizationId;
    private BitSet myWriteMask;
    private final PageLock lock = new PageLock();
    private final Range myContinuousRange = new Range();

    public Page(RandomAccessDataFile owner, long offset) {
        this.owner = owner;
        this.offset = offset;
        this.myKey = new PoolPageKey(owner, offset);
        this.read = false;
        this.dirty = false;
        this.myWriteMask = null;
        assert (offset >= 0L);
    }

    private void ensureRead() {
        if (!this.read) {
            if (this.myWriteMask != null) {
                byte[] content = new byte[4096];
                ByteBuffer b = this.getBuf();
                b.position(0);
                b.get(content, 0, 4096);
                this.owner.loadPage(this);
                int i = this.myWriteMask.nextSetBit(0);
                while (i >= 0) {
                    b.put(i, content[i]);
                    i = this.myWriteMask.nextSetBit(i + 1);
                }
                this.myWriteMask = null;
            } else {
                this.owner.loadPage(this);
            }
            this.read = true;
        }
    }

    private void ensureReadOrWriteMaskExists() {
        this.dirty = true;
        if (this.read || this.myWriteMask != null) {
            return;
        }
        this.myWriteMask = new BitSet(4096);
    }

    @Nullable
    private Range calcContinousRange(BitSet mask) {
        int lowestByte = mask.nextSetBit(0);
        if (lowestByte >= 0) {
            int highestByte = mask.nextClearBit(lowestByte);
            if (highestByte > 0) {
                int nextChunk = mask.nextSetBit(highestByte);
                if (nextChunk < 0) {
                    this.myContinuousRange.start = lowestByte;
                    this.myContinuousRange.end = highestByte;
                    return this.myContinuousRange;
                }
                return null;
            }
            this.myContinuousRange.start = lowestByte;
            this.myContinuousRange.end = 4096;
            return this.myContinuousRange;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                int start = 0;
                int end = 4096;
                if (this.myWriteMask != null) {
                    Range range = this.calcContinousRange(this.myWriteMask);
                    if (range == null) {
                        this.ensureRead();
                    } else {
                        start = range.start;
                        end = range.end;
                    }
                    this.myWriteMask = null;
                }
                if (end - start > 0) {
                    this.owner.flushPage(this, start, end);
                }
                this.dirty = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuf() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.buf == null) {
                LimitedPool<ByteBuffer> limitedPool = ourBufferPool;
                synchronized (limitedPool) {
                    this.buf = ourBufferPool.alloc();
                }
            }
            return this.buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle() {
        if (this.buf != null) {
            LimitedPool<ByteBuffer> limitedPool = ourBufferPool;
            synchronized (limitedPool) {
                ourBufferPool.recycle(this.buf);
            }
        }
        this.buf = null;
        this.read = false;
        this.dirty = false;
        this.myWriteMask = null;
    }

    public long getOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put(long index, byte[] bytes, int off, int length) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            this.myFinalizationId = 0;
            this.ensureReadOrWriteMaskExists();
            int start = (int)(index - this.offset);
            ByteBuffer b = this.getBuf();
            b.position(start);
            int count = Math.min(length, 4096 - start);
            b.put(bytes, off, count);
            if (this.myWriteMask != null) {
                this.myWriteMask.set(start, start + count);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(long index, byte[] bytes, int off, int length) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            this.myFinalizationId = 0;
            this.ensureRead();
            int start = (int)(index - this.offset);
            ByteBuffer b = this.getBuf();
            b.position(start);
            int count = Math.min(length, 4096 - start);
            b.get(bytes, off, count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FinalizationRequest prepareForFinalization(int finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                this.myFinalizationId = finalizationId;
                return new FinalizationRequest(this, finalizationId);
            }
            this.recycle();
            return null;
        }
    }

    public RandomAccessDataFile getOwner() {
        return this.owner;
    }

    public PoolPageKey getKey() {
        return this.myKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.flush();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycleIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.recycle();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            return "Page[" + this.owner + ", dirty: " + this.dirty + ", offset=" + this.offset + "]";
        }
    }

    private static class Range {
        int start;
        int end;

        private Range() {
        }
    }

    private static class PageLock {
        private PageLock() {
        }
    }
}

