/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class CharArrayUtil {
    private static final int GET_CHARS_THRESHOLD = 10;

    public static void getChars(CharSequence src, char[] dst, int dstOffset) {
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(CharSequence src, char[] dst, int dstOffset, int len) {
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(0, len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i = buffer.position();
                buffer.get(dst, dstOffset, len);
                buffer.position(i);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(0, len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(0, len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(0, len, dst, dstOffset);
                return;
            }
        }
        for (int i = 0; i < len; ++i) {
            dst[i + dstOffset] = src.charAt(i);
        }
    }

    public static char[] fromSequenceStrict(CharSequence seq) {
        char[] chars = CharArrayUtil.fromSequence(seq);
        if (seq.length() == chars.length) {
            return chars;
        }
        char[] strictchars = new char[seq.length()];
        System.arraycopy(chars, 0, strictchars, 0, seq.length());
        return strictchars;
    }

    public static char[] fromSequenceWithoutCopying(CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0) {
            return buffer.array();
        }
        return null;
    }

    public static char[] fromSequence(CharSequence seq) {
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer) {
            CharBuffer buffer = (CharBuffer)seq;
            if (buffer.hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0) {
                char[] bufArray = buffer.array();
                return bufArray;
            }
            char[] chars = new char[seq.length()];
            buffer.position(0);
            buffer.get(chars);
            buffer.position(0);
            return chars;
        }
        if (seq instanceof StringBuffer) {
            char[] chars = new char[seq.length()];
            ((StringBuffer)seq).getChars(0, seq.length(), chars, 0);
            return chars;
        }
        if (seq instanceof String) {
            char[] chars = new char[seq.length()];
            ((String)seq).getChars(0, seq.length(), chars, 0);
            return chars;
        }
        return ((Object)seq).toString().toCharArray();
    }

    public static int shiftForward(CharSequence buffer, int offset, String chars) {
        while (offset < buffer.length()) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
            ++offset;
        }
        return offset;
    }

    public static int shiftForwardCarefully(CharSequence buffer, int offset, String chars) {
        if (offset + 1 >= buffer.length()) {
            return offset;
        }
        if (!CharArrayUtil.isSuitable(chars, buffer.charAt(offset))) {
            return offset;
        }
        ++offset;
        while (offset < buffer.length()) {
            char c = buffer.charAt(offset);
            if (!CharArrayUtil.isSuitable(chars, c)) {
                return offset - 1;
            }
            ++offset;
        }
        return offset - 1;
    }

    private static boolean isSuitable(String chars, char c) {
        for (int i = 0; i < chars.length(); ++i) {
            if (c != chars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static int shiftForward(char[] buffer, int offset, String chars) {
        return CharArrayUtil.shiftForward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackward(CharSequence buffer, int offset, String chars) {
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static int shiftBackward(char[] buffer, int offset, String chars) {
        return CharArrayUtil.shiftBackward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftForwardUntil(char[] buffer, int offset, String chars) {
        return CharArrayUtil.shiftForwardUntil(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftForwardUntil(CharSequence buffer, int offset, String chars) {
        while (offset < buffer.length()) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            ++offset;
        }
        return offset;
    }

    public static int shiftBackwardUntil(char[] buffer, int offset, String chars) {
        return CharArrayUtil.shiftBackwardUntil(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackwardUntil(CharSequence buffer, int offset, String chars) {
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(char[] buffer, int offset, int bufferEnd, CharSequence s) {
        int len = s.length();
        if (offset + len > bufferEnd) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[offset + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence buffer, int offset, int bufferEnd, CharSequence s) {
        int len = s.length();
        if (offset + len > bufferEnd) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence buffer, int offset, CharSequence s) {
        if (offset + s.length() > buffer.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] buffer1, int start1, int end1, char[] buffer2, int start2, int end2) {
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = start1; i < end1; ++i) {
            if (buffer1[i] == buffer2[i - start1 + start2]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(char[] buffer, String pattern, int fromIndex) {
        char[] chars = pattern.toCharArray();
        int limit = buffer.length - chars.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence buffer, CharSequence pattern, int fromIndex) {
        return CharArrayUtil.indexOf(buffer, pattern, fromIndex, buffer.length());
    }

    public static int indexOf(CharSequence buffer, CharSequence pattern, int fromIndex, int toIndex) {
        int patternLength = pattern.length();
        int limit = toIndex - patternLength;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < patternLength; ++j) {
                if (pattern.charAt(j) != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence buffer, String pattern, int fromIndex) {
        char[] chars = pattern.toCharArray();
        int end = buffer.length() - chars.length;
        if (fromIndex > end) {
            fromIndex = end;
        }
        block0: for (int i = fromIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] buffer, String pattern, int fromIndex) {
        return CharArrayUtil.lastIndexOf(new CharArrayCharSequence(buffer), pattern, fromIndex);
    }

    public static byte[] toByteArray(char[] chars) throws IOException {
        return CharArrayUtil.toByteArray(chars, chars.length);
    }

    public static byte[] toByteArray(char[] chars, int size) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        writer.write(chars, 0, size);
        writer.close();
        return out.toByteArray();
    }

    public static boolean containsOnlyWhiteSpaces(CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    public static boolean subArraysEqual(char[] ca1, int startOffset1, int endOffset1, char[] ca2, int startOffset2, int endOffset2) {
        if (endOffset1 - startOffset1 != endOffset2 - startOffset2) {
            return false;
        }
        for (int i = startOffset1; i < endOffset1; ++i) {
            char c1 = ca1[i];
            char c2 = ca2[i - startOffset1 + startOffset2];
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static TextRange[] getIndents(CharSequence charsSequence, int shift) {
        List result = new ArrayList<TextRange>();
        int whitespaceEnd = -1;
        int lastTextFound = 0;
        for (int i = charsSequence.length() - 1; i >= 0; --i) {
            char charAt = charsSequence.charAt(i);
            boolean isWhitespace = Character.isWhitespace(charAt);
            if (charAt == '\n') {
                result.add(new TextRange(i, (whitespaceEnd >= 0 ? whitespaceEnd : i) + 1).shiftRight(shift));
                whitespaceEnd = -1;
                continue;
            }
            if (whitespaceEnd >= 0) {
                if (isWhitespace) continue;
                lastTextFound = result.size();
                whitespaceEnd = -1;
                continue;
            }
            if (isWhitespace) {
                whitespaceEnd = i;
                continue;
            }
            lastTextFound = result.size();
        }
        if (whitespaceEnd > 0) {
            result.add(new TextRange(0, whitespaceEnd + 1).shiftRight(shift));
        }
        if (lastTextFound < result.size()) {
            result = result.subList(0, lastTextFound);
        }
        return result.toArray(new TextRange[result.size()]);
    }

    public static boolean containLineBreaks(CharSequence seq) {
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }
}

