/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertionContext {
    public static final OffsetKey TAIL_OFFSET = OffsetKey.create("tailOffset", true);
    private final OffsetMap myOffsetMap;
    private final char myCompletionChar;
    private final LookupElement[] myElements;
    private final PsiFile myFile;
    private final Editor myEditor;
    private Runnable myLaterRunnable;
    private boolean myAddCompletionChar;

    public InsertionContext(OffsetMap offsetMap, char completionChar, LookupElement[] elements, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/completion/InsertionContext.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/completion/InsertionContext.<init> must not be null");
        }
        this.myAddCompletionChar = true;
        this.myOffsetMap = offsetMap;
        this.myCompletionChar = completionChar;
        this.myElements = elements;
        this.myFile = file;
        this.myEditor = editor;
        this.setTailOffset(editor.getCaretModel().getOffset());
    }

    public void setTailOffset(int offset) {
        this.myOffsetMap.addOffset(TAIL_OFFSET, offset);
    }

    public int getTailOffset() {
        return this.myOffsetMap.getOffset(TAIL_OFFSET);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/InsertionContext.getFile must not return null");
        }
        return psiFile;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/InsertionContext.getEditor must not return null");
        }
        return editor;
    }

    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.START_OFFSET);
    }

    public char getCompletionChar() {
        return this.myCompletionChar;
    }

    public LookupElement[] getElements() {
        return this.myElements;
    }

    public Project getProject() {
        return this.myFile.getProject();
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    @Nullable
    public Runnable getLaterRunnable() {
        return this.myLaterRunnable;
    }

    public void setLaterRunnable(@Nullable Runnable laterRunnable) {
        this.myLaterRunnable = laterRunnable;
    }

    public void setAddCompletionChar(boolean addCompletionChar) {
        this.myAddCompletionChar = addCompletionChar;
    }

    public boolean shouldAddCompletionChar() {
        return this.myAddCompletionChar;
    }
}

