/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultExecutionResult
implements ExecutionResult {
    private final ExecutionConsole myConsole;
    private final ProcessHandler myProcessHandler;
    private AnAction[] myActions;
    private AnAction[] myRestartActions;
    private List<AnAction> myStopActions = new ArrayList<AnAction>();

    public DefaultExecutionResult(ExecutionConsole console, ProcessHandler processHandler) {
        this(console, processHandler, AnAction.EMPTY_ARRAY);
    }

    public DefaultExecutionResult(ExecutionConsole console, ProcessHandler processHandler, AnAction ... actions) {
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myActions = actions;
    }

    @Override
    public ExecutionConsole getExecutionConsole() {
        return this.myConsole;
    }

    @Override
    public AnAction[] getActions() {
        return this.myActions;
    }

    public void setActions(AnAction ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/DefaultExecutionResult.setActions must not be null");
        }
        this.myActions = actions;
    }

    public AnAction[] getRestartActions() {
        return this.myRestartActions;
    }

    public void setRestartActions(AnAction ... restartActions) {
        this.myRestartActions = restartActions;
    }

    public void addStopAction(AnAction action) {
        this.myStopActions.add(action);
    }

    @NotNull
    public AnAction[] getAdditionalStopActions() {
        AnAction[] anActionArray = this.myStopActions.toArray(new AnAction[this.myStopActions.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/DefaultExecutionResult.getAdditionalStopActions must not return null");
        }
        return anActionArray;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public static class StopAction
    extends AnAction
    implements DumbAware {
        private final ProcessHandler myProcessHandler;

        public StopAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message("run.configuration.stop.action.name", new Object[0]), null, IconLoader.getIcon((String)"/actions/suspend.png"));
            this.getTemplatePresentation().setEnabled(false);
            this.myProcessHandler = processHandler;
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            if (this.myProcessHandler.detachIsDefault()) {
                this.myProcessHandler.detachProcess();
            } else {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        public void update(AnActionEvent event) {
            event.getPresentation().setEnabled(!this.myProcessHandler.isProcessTerminating() && !this.myProcessHandler.isProcessTerminated());
        }
    }
}

