/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class OpenFileHyperlinkInfo
implements FileHyperlinkInfo {
    private final OpenFileDescriptor myDescriptor;

    public OpenFileHyperlinkInfo(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/filters/OpenFileHyperlinkInfo.<init> must not be null");
        }
        this.myDescriptor = descriptor;
    }

    public OpenFileHyperlinkInfo(Project project, @NotNull VirtualFile file, int line, int column) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/filters/OpenFileHyperlinkInfo.<init> must not be null");
        }
        this(new OpenFileDescriptor(project, file, line, column));
    }

    public OpenFileHyperlinkInfo(Project project, @NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/filters/OpenFileHyperlinkInfo.<init> must not be null");
        }
        this(project, file, line, 0);
    }

    @Override
    public OpenFileDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public void navigate(final Project project) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile file = OpenFileHyperlinkInfo.this.myDescriptor.getFile();
                if (file.isValid()) {
                    FileEditorManager.getInstance(project).openTextEditor(OpenFileHyperlinkInfo.this.myDescriptor, true);
                }
            }
        });
    }
}

