/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiElement;
import java.util.List;

public class LanguageFolding
extends LanguageExtension<FoldingBuilder> {
    public static final LanguageFolding INSTANCE = new LanguageFolding();

    private LanguageFolding() {
        super("com.intellij.lang.foldingBuilder");
    }

    @Override
    public FoldingBuilder forLanguage(Language l) {
        FoldingBuilder result;
        FoldingBuilder cached = (FoldingBuilder)l.getUserData(this.getLanguageCache());
        if (cached != null) {
            return cached;
        }
        List<FoldingBuilder> extensions = this.forKey(l);
        if (extensions.isEmpty()) {
            Language base = l.getBaseLanguage();
            result = base != null ? this.forLanguage(base) : (FoldingBuilder)this.getDefaultImplementation();
        } else {
            return extensions.size() == 1 ? (FoldingBuilder)extensions.get(0) : new CompositeFoldingBuilder(extensions);
        }
        l.putUserData(this.getLanguageCache(), result);
        return result;
    }

    public static FoldingDescriptor[] buildFoldingDescriptors(FoldingBuilder builder, PsiElement root, Document document, boolean quick) {
        if (!(builder instanceof DumbAware) && DumbService.getInstance(root.getProject()).isDumb()) {
            return FoldingDescriptor.EMPTY;
        }
        if (builder instanceof FoldingBuilderEx) {
            return ((FoldingBuilderEx)builder).buildFoldRegions(root, document, quick);
        }
        ASTNode astNode = root.getNode();
        if (astNode == null || builder == null) {
            return FoldingDescriptor.EMPTY;
        }
        return builder.buildFoldRegions(astNode, document);
    }
}

