/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ImmutableUserMap;
import java.util.List;

public abstract class LookAheadLexer
extends LexerBase {
    private int myLastOffset;
    private int myLastState;
    private final Lexer myBaseLexer;
    private int myTokenStart;
    private final List<IElementType> myTypeCache = new SmartList();
    private final List<Integer> myEndOffsetCache = new SmartList();

    public LookAheadLexer(Lexer baseLexer) {
        this.myBaseLexer = baseLexer;
    }

    protected void addToken(IElementType type) {
        this.addToken(this.myBaseLexer.getTokenEnd(), type);
    }

    protected void addToken(int endOffset, IElementType type) {
        this.myTypeCache.add(type);
        this.myEndOffsetCache.add(endOffset);
    }

    protected void lookAhead(Lexer baseLexer) {
        this.addToken(baseLexer.getTokenType());
        baseLexer.advance();
    }

    @Override
    public void advance() {
        if (!this.myTypeCache.isEmpty()) {
            this.myTypeCache.remove(0);
            this.myTokenStart = this.myEndOffsetCache.remove(0);
        }
        if (this.myTypeCache.isEmpty()) {
            this.doLookAhead();
        }
    }

    private void doLookAhead() {
        this.myLastOffset = this.myTokenStart;
        this.myLastState = this.myBaseLexer.getState();
        this.lookAhead(this.myBaseLexer);
        assert (!this.myTypeCache.isEmpty());
    }

    @Override
    public CharSequence getBufferSequence() {
        return this.myBaseLexer.getBufferSequence();
    }

    @Override
    public int getBufferEnd() {
        return this.myBaseLexer.getBufferEnd();
    }

    @Override
    public int getState() {
        int offset = this.myTypeCache.size() - 1;
        return this.myLastState | offset << 16;
    }

    @Override
    public int getTokenEnd() {
        return this.myEndOffsetCache.get(0);
    }

    @Override
    public int getTokenStart() {
        return this.myTokenStart;
    }

    @Override
    public LookAheadLexerPosition getCurrentPosition() {
        return new LookAheadLexerPosition(ImmutableUserMap.EMPTY);
    }

    @Override
    public final void restore(LexerPosition _position) {
        this.restore((LookAheadLexerPosition)_position);
    }

    protected void restore(LookAheadLexerPosition position) {
        this.start(this.myBaseLexer.getBufferSequence(), position.lastOffset, this.myBaseLexer.getBufferEnd(), position.lastState);
        for (int i = 0; i < position.advanceCount; ++i) {
            this.advance();
        }
    }

    @Override
    public IElementType getTokenType() {
        return this.myTypeCache.get(0);
    }

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBaseLexer.start(buffer, startOffset, endOffset, initialState & 0xFFFF);
        this.myTokenStart = startOffset;
        this.myTypeCache.clear();
        this.myEndOffsetCache.clear();
        this.doLookAhead();
    }

    protected class LookAheadLexerPosition
    implements LexerPosition {
        final int lastOffset;
        final int lastState;
        final int tokenStart;
        final int curState;
        final int advanceCount;
        final ImmutableUserMap customMap;

        public LookAheadLexerPosition(ImmutableUserMap map) {
            this.lastOffset = LookAheadLexer.this.myLastOffset;
            this.lastState = LookAheadLexer.this.myLastState;
            this.tokenStart = LookAheadLexer.this.myTokenStart;
            this.curState = this.getState();
            this.advanceCount = LookAheadLexer.this.myTypeCache.size() - 1;
            this.customMap = map;
        }

        public ImmutableUserMap getCustomMap() {
            return this.customMap;
        }

        @Override
        public int getOffset() {
            return this.tokenStart;
        }

        @Override
        public int getState() {
            return this.lastState;
        }
    }
}

