/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExactFileNameMatcher
implements FileNameMatcher {
    private final String myFileName;
    private final boolean myIgnoreCase;

    public ExactFileNameMatcher(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExactFileNameMatcher.<init> must not be null");
        }
        this.myFileName = fileName;
        this.myIgnoreCase = false;
    }

    public ExactFileNameMatcher(@NotNull @NonNls String fileName, boolean ignoreCase) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExactFileNameMatcher.<init> must not be null");
        }
        this.myFileName = fileName;
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public boolean accept(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExactFileNameMatcher.accept must not be null");
        }
        return Comparing.equal((String)fileName, (String)this.myFileName, (SystemInfo.isFileSystemCaseSensitive && !this.myIgnoreCase ? 1 : 0) != 0);
    }

    @Override
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/ExactFileNameMatcher.getPresentableString must not return null");
        }
        return string;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExactFileNameMatcher that = (ExactFileNameMatcher)o;
        return this.myFileName.equals(that.myFileName);
    }

    public int hashCode() {
        return this.myFileName.hashCode();
    }
}

