/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class TextFieldWithBrowseButton
extends ComponentWithBrowseButton<JTextField> {
    public TextFieldWithBrowseButton() {
        this((ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field) {
        this(field, (ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field, ActionListener browseActionListener) {
        super(field, browseActionListener);
        DataManager manager;
        if (ApplicationManager.getApplication() != null && (manager = DataManager.getInstance()) != null) {
            this.installPathCompletion(PlatformDataKeys.PROJECT.getData(manager.getDataContext()), FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
        }
    }

    public TextFieldWithBrowseButton(ActionListener browseActionListener) {
        this(new JTextField(), browseActionListener);
    }

    public void addBrowseFolderListener(String title, String description, Project project, FileChooserDescriptor fileChooserDescriptor) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.installPathCompletion(project, fileChooserDescriptor);
    }

    protected void installPathCompletion(Project project, FileChooserDescriptor fileChooserDescriptor) {
        this.installPathCompletion(project, fileChooserDescriptor, null);
    }

    protected void installPathCompletion(Project project, FileChooserDescriptor fileChooserDescriptor, Disposable parent) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        FileChooserFactory.getInstance().installFileCompletion((JTextField)this.getChildComponent(), fileChooserDescriptor, true, parent);
    }

    public JTextField getTextField() {
        return (JTextField)this.getChildComponent();
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public void setText(String text) {
        this.getTextField().setText(text);
    }

    public boolean isEditable() {
        return this.getTextField().isEditable();
    }

    public void setEditable(boolean b) {
        this.getTextField().setEditable(b);
        this.getButton().setFocusable(!b);
        this.getTextField().setFocusable(b);
    }

    public static class NoPathCompletion
    extends TextFieldWithBrowseButton {
        public NoPathCompletion() {
        }

        public NoPathCompletion(JTextField field) {
            super(field);
        }

        public NoPathCompletion(JTextField field, ActionListener browseActionListener) {
            super(field, browseActionListener);
        }

        public NoPathCompletion(ActionListener browseActionListener) {
            super(browseActionListener);
        }

        @Override
        protected void installPathCompletion(Project project, FileChooserDescriptor fileChooserDescriptor) {
        }
    }
}

