/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaStatisticsManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.statistics.JavaStatisticsManager");
    protected static final int MAX_NAME_SUGGESTIONS_COUNT = 5;
    @NonNls
    public static final String CLASS_PREFIX = "class#";

    @Nullable
    public static NameContext getContext(PsiElement element) {
        if (element instanceof PsiField) {
            if (((PsiField)element).hasModifierProperty("static") && ((PsiField)element).hasModifierProperty("final")) {
                return NameContext.CONSTANT_NAME;
            }
            return NameContext.FIELD_NAME;
        }
        if (element instanceof PsiLocalVariable) {
            return NameContext.LOCAL_VARIABLE_NAME;
        }
        return null;
    }

    private static StatisticsInfo createVariableUseInfo(String name, VariableKind variableKind, String propertyName, PsiType type) {
        String key1 = JavaStatisticsManager.getVariableNameUseKey1(propertyName, type);
        String key2 = JavaStatisticsManager.getVariableNameUseKey2(variableKind, name);
        return new StatisticsInfo(key1, key2);
    }

    private static String getVariableNameUseKey1(String propertyName, PsiType type) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("variableName#");
        if (propertyName != null) {
            buffer.append(propertyName);
        }
        buffer.append("#");
        if (type != null) {
            buffer.append(type.getCanonicalText());
        }
        return buffer.toString();
    }

    private static String getVariableNameUseKey2(VariableKind kind, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)kind);
        buffer.append("#");
        buffer.append(name);
        return buffer.toString();
    }

    public static int getVariableNameUseCount(String name, VariableKind variableKind, String propertyName, PsiType type) {
        return JavaStatisticsManager.createVariableUseInfo(name, variableKind, propertyName, type).getUseCount();
    }

    public static void incVariableNameUseCount(String name, VariableKind variableKind, String propertyName, PsiType type) {
        JavaStatisticsManager.createVariableUseInfo(name, variableKind, propertyName, type).incUseCount();
    }

    @Nullable
    private static NameContext getNameUsageContext(String key2) {
        int startIndex = key2.indexOf("#");
        LOG.assertTrue(startIndex >= 0);
        String s = key2.substring(0, startIndex);
        if (!"variableName".equals(s)) {
            return null;
        }
        int index = key2.indexOf("#", startIndex + 1);
        s = key2.substring(startIndex + 1, index);
        return NameContext.valueOf(s);
    }

    @Nullable
    public static String getName(String key2) {
        int startIndex = key2.indexOf("#");
        LOG.assertTrue(startIndex >= 0);
        String s = key2.substring(0, startIndex);
        if (!"variableName".equals(s)) {
            return null;
        }
        int index = key2.indexOf("#", startIndex + 1);
        LOG.assertTrue(index >= 0);
        return key2.substring(index + 1);
    }

    private static VariableKind getVariableKindFromKey2(String key2) {
        int index = key2.indexOf("#");
        LOG.assertTrue(index >= 0);
        String s = key2.substring(0, index);
        return VariableKind.valueOf(s);
    }

    private static String getVariableNameFromKey2(String key2) {
        int index = key2.indexOf("#");
        LOG.assertTrue(index >= 0);
        return key2.substring(index + 1);
    }

    @NonNls
    @NotNull
    public static String getMemberUseKey1(PsiType qualifierType) {
        qualifierType = TypeConversionUtil.erasure(qualifierType);
        String string = "member#" + (qualifierType == null ? "" : qualifierType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/statistics/JavaStatisticsManager.getMemberUseKey1 must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public static String getNameUseKey1(PsiType qualifierType) {
        qualifierType = TypeConversionUtil.erasure(qualifierType);
        String string = "memberForName#" + (qualifierType == null ? "" : qualifierType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/statistics/JavaStatisticsManager.getNameUseKey1 must not return null");
        }
        return string;
    }

    @NonNls
    public static String getMemberUseKey2(PsiMember member) {
        if (member instanceof PsiMethod) {
            PsiParameter[] parms;
            PsiMethod method = (PsiMethod)member;
            StringBuilder buffer = new StringBuilder();
            buffer.append("method#");
            buffer.append(method.getName());
            for (PsiParameter parm : parms = method.getParameterList().getParameters()) {
                buffer.append("#");
                buffer.append(parm.getType().getPresentableText());
            }
            return buffer.toString();
        }
        if (member instanceof PsiField) {
            return "field#" + member.getName();
        }
        return CLASS_PREFIX + ((PsiClass)member).getQualifiedName();
    }

    public static StatisticsInfo createInfo(PsiType qualifierType, PsiMember member) {
        return new StatisticsInfo(JavaStatisticsManager.getMemberUseKey1(qualifierType), JavaStatisticsManager.getMemberUseKey2(member));
    }

    private static StatisticsInfo createNameUseInfo(PsiType type, NameContext context, String name) {
        return new StatisticsInfo(JavaStatisticsManager.getNameUseKey1(type), JavaStatisticsManager.getNameUseKey(context, name));
    }

    private static String getNameUseKey(NameContext context, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("variableName#");
        buffer.append(context.name());
        buffer.append('#');
        buffer.append(name);
        return buffer.toString();
    }

    public static String[] getAllVariableNamesUsed(VariableKind variableKind, String propertyName, PsiType type) {
        StatisticsInfo[] keys2 = StatisticsManager.getInstance().getAllValues(JavaStatisticsManager.getVariableNameUseKey1(propertyName, type));
        ArrayList<String> list = new ArrayList<String>();
        for (StatisticsInfo key2 : keys2) {
            VariableKind variableKind1 = JavaStatisticsManager.getVariableKindFromKey2(key2.getValue());
            if (variableKind1 != variableKind) continue;
            String name = JavaStatisticsManager.getVariableNameFromKey2(key2.getValue());
            list.add(name);
        }
        return ArrayUtil.toStringArray(list);
    }

    public static String getAfterNewKey(PsiType expectedType) {
        return JavaStatisticsManager.getMemberUseKey1(expectedType) + "###smartAfterNew";
    }

    public static String[] getNameSuggestions(PsiType type, NameContext context, String prefix) {
        ArrayList<String> suggestions = new ArrayList<String>();
        String key1 = JavaStatisticsManager.getNameUseKey1(type);
        Object[] possibleNames = StatisticsManager.getInstance().getAllValues(key1);
        Arrays.sort(possibleNames);
        for (int i = 0; i < possibleNames.length && suggestions.size() < 5; ++i) {
            String name;
            String key2 = ((StatisticsInfo)possibleNames[i]).getValue();
            if (context != JavaStatisticsManager.getNameUsageContext(key2) || (name = JavaStatisticsManager.getName(key2)) == null || !name.startsWith(prefix)) continue;
            suggestions.add(name);
        }
        return ArrayUtil.toStringArray(suggestions);
    }

    public static void incNameUseCount(PsiType type, NameContext context, String name) {
        JavaStatisticsManager.createNameUseInfo(type, context, name).incUseCount();
    }

    public static enum NameContext {
        LOCAL_VARIABLE_NAME,
        FIELD_NAME,
        CONSTANT_NAME;

    }
}

